/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.entry;

import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTagRegistry;
import com.simibubi.create.infrastructure.ponder.AllPonderTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import plus.dragons.createcentralkitchen.CentralKitchen;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.BasketPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.BlazeStovePoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.CookingPotPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.CopperPotPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.CuttingBoardPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.SkilletPoint;
import plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm.StovePoint;
import plus.dragons.createcentralkitchen.foundation.ponder.PonderArmInteractionPointType;
import plus.dragons.createcentralkitchen.foundation.utility.Mods;

@Mod.EventBusSubscriber(modid="create_central_kitchen", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CentralKitchenArmInterationTypes {
    public static final List<PonderArmInteractionPointType> TYPES = new ArrayList<PonderArmInteractionPointType>();
    public static final CuttingBoardPoint.Type CUTTING_BOARD = CentralKitchenArmInterationTypes.create("cutting_board", CuttingBoardPoint.Type::new);
    public static final BasketPoint.Type BASKET = CentralKitchenArmInterationTypes.create("basket", BasketPoint.Type::new);
    public static final StovePoint.Type STOVE = CentralKitchenArmInterationTypes.create("stove", StovePoint.Type::new);
    public static final BlazeStovePoint.Type BLAZE_STOVE = CentralKitchenArmInterationTypes.create("blaze_stove", BlazeStovePoint.Type::new);
    public static final CookingPotPoint.Type COOKING_POT = CentralKitchenArmInterationTypes.create("cooking_pot", CookingPotPoint.Type::new);
    public static final SkilletPoint.Type SKILLET = CentralKitchenArmInterationTypes.create("skillet", SkilletPoint.Type::new);
    public static final CopperPotPoint.Type COPPER_POT = CentralKitchenArmInterationTypes.create("copper_pot", CopperPotPoint.Type::new);

    private static <T extends PonderArmInteractionPointType> T create(String name, Function<ResourceLocation, T> factory) {
        ResourceLocation id = CentralKitchen.genRL(name);
        return (T)((Object)((PonderArmInteractionPointType)((Object)factory.apply(id))));
    }

    private static void register(PonderArmInteractionPointType ... types) {
        for (PonderArmInteractionPointType type : types) {
            ArmInteractionPointType.register((ArmInteractionPointType)type);
            TYPES.add(type);
        }
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        ModList mods = ModList.get();
        if (Mods.isLoaded("farmersdelight")) {
            CentralKitchenArmInterationTypes.register(STOVE, BLAZE_STOVE, COOKING_POT, SKILLET, CUTTING_BOARD, BASKET);
        }
        if (Mods.isLoaded("miners_delight")) {
            CentralKitchenArmInterationTypes.register(COPPER_POT);
        }
    }

    @SubscribeEvent
    public static void registerPonderTags(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Consumer<ItemLike> consumer = arg_0 -> ((PonderTagRegistry.TagBuilder)PonderRegistry.TAGS.forTag(AllPonderTags.ARM_TARGETS)).add(arg_0);
            for (PonderArmInteractionPointType type : TYPES) {
                type.addToPonderTag(consumer);
            }
        });
    }
}

