/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.contraptions.blazeStove;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveBlockEntity;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveGuideItem;
import plus.dragons.createcentralkitchen.entry.block.entity.FDBlockEntityEntries;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;

public class BlazeStoveBlock
extends HorizontalDirectionalBlock
implements IBE<BlazeStoveBlockEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> HEAT_LEVEL = BlazeBurnerBlock.HEAT_LEVEL;
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});

    public BlazeStoveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING));
    }

    public Item m_5456_() {
        return ((BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get()).m_5456_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, POWERED, HEAT_LEVEL});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            if (!level.m_5776_()) {
                this.withBlockEntityDo((BlockGetter)level, pos, stove -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)stove, buf -> {
                    buf.m_130055_(stove.getGuide());
                    buf.writeBoolean(false);
                    buf.m_130064_(pos);
                }));
            }
            return InteractionResult.SUCCESS;
        }
        boolean noConsume = player.m_7500_();
        boolean forceOverflow = !(player instanceof FakePlayer);
        InteractionResultHolder<ItemStack> holder = BlazeStoveBlock.tryInsert(level, pos, stack, noConsume, forceOverflow, false);
        ItemStack leftover = (ItemStack)holder.m_19095_();
        if (!(level.f_46443_ || noConsume || leftover.m_41619_())) {
            if (stack.m_41619_()) {
                player.m_21008_(hand, leftover);
            } else if (!player.m_150109_().m_36054_(leftover)) {
                player.m_36176_(leftover, false);
            }
        }
        return holder.m_19089_().m_146666_() ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> tryInsert(Level level, BlockPos pos, ItemStack stack, boolean noConsume, boolean forceOverflow, boolean simulate) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BlazeStoveBlockEntity)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        BlazeStoveBlockEntity stove = (BlazeStoveBlockEntity)blockEntity;
        if (stack.m_41720_() instanceof BlazeStoveGuideItem) {
            ItemStack original = stove.getGuide();
            if (!level.m_5776_()) {
                ItemStack guide = stack.m_41777_().m_41620_(1);
                if (!simulate) {
                    stove.setGuide(guide);
                }
            }
            return InteractionResultHolder.m_19090_((Object)original);
        }
        if (stove.isCreativeFuel(stack)) {
            if (!simulate) {
                stove.applyCreativeFuel();
            }
            return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
        }
        if (!stove.tryUpdateFuel(stack, forceOverflow, simulate) && !stove.tryAddIngredient(stack, forceOverflow, simulate)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        if (!noConsume) {
            ItemStack container;
            ItemStack itemStack = container = stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_;
            if (!level.f_46443_) {
                stack.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)container);
        }
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            level.m_186460_(pos, (Block)this, 2);
        }
        this.updateNeighborsInFront((Level)level, pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) != 0) {
            return;
        }
        if (!((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.SMOULDERING)) {
            return;
        }
        world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
    }

    public void startSignal(LevelAccessor level, BlockPos pos) {
        if (!level.m_5776_() && !level.m_183326_().m_183582_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 2);
        }
    }

    protected void updateNeighborsInFront(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos posFront = pos.m_121945_(facing.m_122424_());
        level.m_46586_(posFront, (Block)this, pos);
        level.m_46590_(posFront, (Block)this, facing);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction == state.m_61143_((Property)f_54117_);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return state.m_60746_(level, pos, side);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && state.m_61143_((Property)f_54117_) == side ? 15 : 0;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return Math.max(0, ((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)).ordinal() - 1);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        AdvancementBehaviour.setPlacedBy((Level)level, (BlockPos)pos, (LivingEntity)placer);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos.m_7494_());
        if (blockEntity instanceof BasinBlockEntity) {
            BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
            basin.notifyChangeOfContents();
        }
        if (!state.m_60713_(oldState.m_60734_()) && !level.m_5776_() && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !level.m_183326_().m_183582_(pos, (Object)this)) {
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
            level.m_7731_(pos, state, 18);
            this.updateNeighborsInFront(level, pos, state);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && level.m_183326_().m_183582_(pos, (Object)this)) {
            this.updateNeighborsInFront(level, pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_46597_(pos, (BlockState)((BlockState)AllBlocks.BLAZE_BURNER.getDefaultState().m_61124_((Property)BlazeBurnerBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_(HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity living;
        float damage;
        switch ((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)) {
            case SEETHING: {
                float f = 2.0f;
                break;
            }
            case KINDLED: 
            case FADING: {
                float f = 1.0f;
                break;
            }
            case SMOULDERING: {
                float f = 0.5f;
                break;
            }
            default: {
                float f = damage = -1.0f;
            }
        }
        if (damage > 0.0f && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)(living = (LivingEntity)entity))) {
            entity.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)level, (ResourceKey)ModDamageTypes.STOVE_BURN), damage);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public Class<BlazeStoveBlockEntity> getBlockEntityClass() {
        return BlazeStoveBlockEntity.class;
    }

    public BlockEntityType<? extends BlazeStoveBlockEntity> getBlockEntityType() {
        return (BlockEntityType)FDBlockEntityEntries.BLAZE_STOVE.get();
    }
}

