/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.projectile.Cannon;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.item.ModItems;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public interface Cannonable
extends Ability {
    public float getDefaultCannonPower();

    public CannonPosition getCannonPosition(int var1);

    public byte getMaxCannonPerSide();

    default public void tickCannonShip() {
        for (Cannon cannon : this.getCannons()) {
            cannon.m_8119_();
            if (!this.self().isCannonKeyPressed() || !this.canShoot()) continue;
            this.triggerCannon(cannon);
        }
    }

    default public void triggerCannon(Cannon cannon) {
        if (cannon.canShootDirection()) {
            cannon.trigger();
        }
    }

    default public void triggerCannons(Vec3 shootVec, double yShootVec, LivingEntity driverEntity, double speed, double accuracy) {
        if (this.canShoot()) {
            for (Cannon cannon : this.getCannons()) {
                this.triggerCannonAdvanced(cannon, shootVec, yShootVec, driverEntity, speed, accuracy);
            }
        }
    }

    default public void triggerCannonAdvanced(Cannon cannon, Vec3 shootVec, double yShootVec, LivingEntity driverEntity, double speed, double accuracy) {
        if (cannon.canShootDirection()) {
            cannon.trigger(shootVec, yShootVec, driverEntity, speed, accuracy);
        }
    }

    default public void defineCannonShipSynchedData() {
        this.self().m_20088_().m_135372_(Ship.CANNON_POWER, (Object)Float.valueOf(this.getDefaultCannonPower()));
        this.self().m_20088_().m_135372_(Ship.CANNON_COUNT, (Object)0);
    }

    default public void readCannonShipSaveData(CompoundTag tag) {
        if (tag.m_128441_("CannonCount")) {
            this.setCannonCount(tag.m_128445_("CannonCount"));
            this.updateCannonCount();
        }
    }

    default public void addCannonShipSaveData(CompoundTag tag) {
        tag.m_128405_("CannonCount", (int)this.getCannonCount());
    }

    default public float getCannonModifier() {
        return (float)this.getCannonCount() * ((Double)SmallShipsConfig.Common.shipGeneralCannonModifier.get()).floatValue();
    }

    default public void updateCannonCount() {
        int cannons = this.getCannonCount();
        this.getCannons().clear();
        for (int i = 0; i < cannons; ++i) {
            CannonPosition cannonPosition = this.getCannonPosition(i);
            if (cannonPosition == null) continue;
            Cannon cannon = new Cannon(this.self(), cannonPosition);
            this.getCannons().add(cannon);
        }
        this.setCannonCount((byte)cannons);
    }

    default public boolean interactCannon(Player player, InteractionHand interactionHand) {
        ItemStack item = player.m_21120_(interactionHand);
        byte cannonCount = this.getCannonCount();
        if (item.m_41720_() == ModItems.CANNON && this.self() instanceof ContainerShip) {
            if (cannonCount >= this.getMaxCannonPerSide() * 2) {
                return false;
            }
            this.setCannonCount((byte)(cannonCount + 1));
            this.self().m_9236_().m_6263_(player, this.self().m_20185_(), this.self().m_20186_() + 4.0, this.self().m_20189_(), SoundEvents.f_11672_, this.self().m_5720_(), 15.0f, 1.5f);
            if (!player.m_7500_()) {
                item.m_41774_(1);
            }
            this.updateCannonCount();
            return true;
        }
        if (item.m_41720_() instanceof AxeItem && cannonCount > 0) {
            this.setCannonCount((byte)(cannonCount - 1));
            this.self().m_19998_((ItemLike)ModItems.CANNON);
            this.self().m_9236_().m_6263_(player, this.self().m_20185_(), this.self().m_20186_() + 4.0, this.self().m_20189_(), SoundEvents.f_11672_, this.self().m_5720_(), 15.0f, 1.0f);
            return true;
        }
        return false;
    }

    default public boolean canShoot() {
        Ship ship = this.self();
        if (ship instanceof ContainerEntity) {
            ContainerEntity containerEntity = (ContainerEntity)ship;
            return containerEntity.m_213659_().stream().anyMatch(itemStack -> itemStack.m_41720_().equals(ModItems.CANNON_BALL));
        }
        ship = this.self().m_6688_();
        if (ship instanceof Player) {
            Player player = (Player)ship;
            return player.m_150109_().f_35974_.stream().anyMatch(itemStack -> itemStack.m_41720_().equals(ModItems.CANNON_BALL));
        }
        return false;
    }

    default public void consumeCannonBall() {
        block2: {
            Object object;
            block3: {
                object = this.self();
                if (!(object instanceof ContainerEntity)) break block3;
                ContainerEntity containerEntity = (ContainerEntity)object;
                for (ItemStack itemstack : containerEntity.m_213659_()) {
                    if (!itemstack.m_150930_(ModItems.CANNON_BALL)) continue;
                    itemstack.m_41774_(1);
                    break block2;
                }
                break block2;
            }
            object = this.self().m_6688_();
            if (!(object instanceof Player)) break block2;
            Player player = (Player)object;
            for (ItemStack itemstack : player.m_150109_().f_35974_) {
                if (!itemstack.m_150930_(ModItems.CANNON_BALL)) continue;
                itemstack.m_41774_(1);
                break;
            }
        }
    }

    default public ResourceLocation getTextureLocation() {
        return new ResourceLocation("smallships", "textures/entity/cannon/ship_cannon.png");
    }

    default public void setCannonCount(byte x) {
        this.self().m_20088_().m_135381_(Ship.CANNON_COUNT, (Object)x);
    }

    default public byte getCannonCount() {
        return (Byte)this.self().m_20088_().m_135370_(Ship.CANNON_COUNT);
    }

    default public List<Cannon> getCannons() {
        return this.self().CANNONS;
    }

    public static class CannonPosition {
        public final double x;
        public final double y;
        public final double z;
        public final boolean isRightSided;

        public CannonPosition(double x, double y, double z, boolean isRightSided) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.isRightSided = isRightSided;
        }
    }
}

