/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.item;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class SkateboardMaterials {
    private static Set<Item> SKATEBOARD_MATERIALS = null;

    public static void reload() {
        IWannaSkateMod.LOGGER.info("reloading skateboard materials");
        SKATEBOARD_MATERIALS = (Set)ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(IWSTags.DECK_MATERIALS)).collect(ImmutableSet.toImmutableSet());
    }

    public static Set<Item> getSkateboardMaterials() {
        if (SKATEBOARD_MATERIALS == null || SKATEBOARD_MATERIALS.isEmpty()) {
            SkateboardMaterials.reload();
        }
        return SKATEBOARD_MATERIALS;
    }

    public static boolean isLoaded() {
        return SKATEBOARD_MATERIALS != null && !SKATEBOARD_MATERIALS.isEmpty();
    }

    public static Set<Item> getSkateboardWheels() {
        return (Set)ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(IWSTags.SKATEBOARD_WHEELS)).collect(ImmutableSet.toImmutableSet());
    }

    public static Set<Item> getGrips() {
        return (Set)ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(ItemTags.f_215867_)).collect(ImmutableSet.toImmutableSet());
    }

    public static Set<Item> getBanners() {
        return (Set)ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(ItemTags.f_13191_)).collect(ImmutableSet.toImmutableSet());
    }

    public static SkateboardData generateRandomData(Set<Item> setOfMaterials, RandomSource random, boolean onlyWood) {
        List materials = setOfMaterials.stream().toList();
        Item material = materials.isEmpty() ? Items.f_41914_ : (Item)materials.get(materials.size() > 1 ? random.m_188503_(materials.size() - 1) : 0);
        SkateboardData data = new SkateboardData(ForgeRegistries.ITEMS.getKey((Object)material));
        if (!onlyWood) {
            List banners;
            if (random.m_188503_(17) != 0) {
                data.setGripTape(DyeColor.values()[random.m_188503_(DyeColor.values().length - 1)]);
            }
            data.setWheelType(SkateboardWheels.values()[random.m_188503_(SkateboardWheels.values().length - 1)]);
            if (random.m_188503_(5) != 0 && !(banners = SkateboardMaterials.getBanners().stream().toList()).isEmpty()) {
                Item banner = (Item)banners.get(banners.size() > 1 ? random.m_188503_(banners.size() - 1) : 0);
                CompoundTag bannerTag = new CompoundTag();
                bannerTag.m_128405_("Base", ((BannerItem)banner).m_40545_().m_41060_());
                data.setBanner(bannerTag);
            }
        }
        return data;
    }
}

