/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.sound;

import com.github.alexthe668.iwannaskate.client.ClientProxy;
import com.github.alexthe668.iwannaskate.client.sound.SkateSoundType;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SkateboardSound
extends AbstractTickableSoundInstance {
    protected final SkateboardEntity skateboard;
    private SkateSoundType soundType;
    private float changeProgress;

    public SkateboardSound(SkateSoundType soundType, float startingVolume, SkateboardEntity skateboard) {
        super((SoundEvent)soundType.sound.get(), SoundSource.NEUTRAL, SoundInstance.m_235150_());
        this.soundType = soundType;
        this.skateboard = skateboard;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = startingVolume;
        this.changeProgress = 0.0f;
        this.f_119575_ = this.skateboard.m_20185_();
        this.f_119576_ = this.skateboard.m_20186_();
        this.f_119577_ = this.skateboard.m_20189_();
    }

    public boolean m_7767_() {
        return !this.skateboard.m_20067_() && this.skateboard.canWheelsMakeSound() && (ClientProxy.SKATEBOARD_SOUND_MAP.get(this.skateboard.m_19879_()) == this || this.changeProgress < 1.0f);
    }

    public boolean m_7784_() {
        return true;
    }

    public void m_7788_() {
        boolean flag = this.shouldSwitchSounds();
        if (flag) {
            if (this.changeProgress >= 1.0f) {
                this.m_119609_();
            }
            if (!ClientProxy.SKATEBOARD_SOUND_MAP.containsKey(this.skateboard.m_19879_()) || ClientProxy.SKATEBOARD_SOUND_MAP.get((Object)Integer.valueOf((int)this.skateboard.m_19879_())).soundType != SkateSoundType.getForSkateboard(this.skateboard)) {
                ClientProxy.SKATEBOARD_SOUND_MAP.put(this.skateboard.m_19879_(), this.createNewSoundFrom());
            }
        }
        if (!this.skateboard.m_213877_() && this.skateboard.m_6084_()) {
            this.f_119574_ = 1.0f;
            this.f_119575_ = this.skateboard.m_20185_();
            this.f_119576_ = this.skateboard.m_20186_();
            this.f_119577_ = this.skateboard.m_20189_();
            this.f_119573_ = this.getTargetVolume() * Math.max(0.0f, 1.0f - this.changeProgress);
            if (flag) {
                this.changeProgress += 0.5f;
            }
        } else {
            this.m_119609_();
            ClientProxy.SKATEBOARD_SOUND_MAP.remove(this.skateboard.m_19879_());
        }
    }

    private float getTargetVolume() {
        float f = (float)this.skateboard.m_20184_().m_165924_();
        float volumeLerp = this.skateboard.getOnGroundProgress(1.0f);
        if (this.skateboard.isGrinding()) {
            volumeLerp = 1.0f;
        }
        return Mth.m_14179_((float)Mth.m_14036_((float)((float)Math.pow(f, 0.5) * volumeLerp), (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
    }

    private SkateboardSound createNewSoundFrom() {
        return new SkateboardSound(SkateSoundType.getForSkateboard(this.skateboard), 0.0f, this.skateboard);
    }

    private boolean shouldSwitchSounds() {
        return this.soundType != SkateSoundType.getForSkateboard(this.skateboard);
    }

    public boolean isDifferentBoard(Entity entity) {
        return this.skateboard != entity;
    }
}

