/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PhotographInHandRenderer {
    public static void renderPhotograph(PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, ItemStack stack) {
        Either<String, ResourceLocation> idOrTexture;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85841_(0.38f, 0.38f, 0.38f);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        float scale = 0.00390625f;
        poseStack.m_85841_(scale, scale, -scale);
        Item item = stack.m_41720_();
        if (item instanceof PhotographItem) {
            PhotographItem photographItem = (PhotographItem)item;
            idOrTexture = photographItem.getIdOrTexture(stack);
        } else {
            item = stack.m_41720_();
            if (item instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)item;
                idOrTexture = stackedPhotographsItem.getFirstIdOrTexture(stack);
            } else {
                throw new IllegalArgumentException(stack + " cannot be rendered as a Photograph.");
            }
        }
        if (idOrTexture != null) {
            ExposureClient.getExposureRenderer().renderOnPaper(idOrTexture, poseStack, bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, combinedLight, 255, 255, 255, 255, false);
        } else {
            ExposureClient.getExposureRenderer().renderPaperTexture(poseStack, bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, combinedLight, 255, 255, 255, 255);
        }
    }
}

