/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.recipe.AbstractNbtTransferringRecipe;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class PhotographCopyingRecipe
extends AbstractNbtTransferringRecipe {
    public PhotographCopyingRecipe(ResourceLocation id, Ingredient transferIngredient, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, transferIngredient, ingredients, result);
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Exposure.RecipeSerializers.PHOTOGRAPH_CLONING.get();
    }

    @Override
    @NotNull
    public ItemStack transferNbt(ItemStack photographStack, ItemStack recipeResultStack) {
        if (photographStack.m_41720_() instanceof PhotographItem && photographStack.m_41782_() && WrittenBookItem.m_43473_((ItemStack)photographStack) < 2) {
            ItemStack result = super.transferNbt(photographStack, recipeResultStack);
            CompoundTag resultTag = result.m_41784_();
            resultTag.m_128405_("generation", Math.min(WrittenBookItem.m_43473_((ItemStack)result) + 1, 2));
            return result;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pInv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)pInv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = pInv.m_8020_(i);
            if (itemstack.m_41720_().m_41470_()) {
                nonnulllist.set(i, (Object)new ItemStack((ItemLike)Objects.requireNonNull(itemstack.m_41720_().m_41469_())));
                continue;
            }
            if (!(itemstack.m_41720_() instanceof PhotographItem)) continue;
            ItemStack itemstack1 = itemstack.m_41777_();
            itemstack1.m_41764_(1);
            nonnulllist.set(i, (Object)itemstack1);
            break;
        }
        return nonnulllist;
    }

    public static class Serializer
    implements RecipeSerializer<PhotographCopyingRecipe> {
        @NotNull
        public PhotographCopyingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient photographIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)serializedRecipe, (String)"photograph"));
            NonNullList<Ingredient> ingredients = this.getIngredients(GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"ingredients"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"result"));
            if (photographIngredient.m_43947_()) {
                throw new JsonParseException("Recipe should have 'photograph' ingredient.");
            }
            return new PhotographCopyingRecipe(recipeId, photographIngredient, ingredients, result);
        }

        @NotNull
        public PhotographCopyingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient transferredIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ingredientsCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsCount, (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack result = buffer.m_130267_();
            return new PhotographCopyingRecipe(recipeId, transferredIngredient, (NonNullList<Ingredient>)ingredients, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, PhotographCopyingRecipe recipe) {
            recipe.getTransferIngredient().m_43923_(buffer);
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.getResult());
        }

        private NonNullList<Ingredient> getIngredients(JsonArray jsonArray) {
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for a recipe.");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for a recipe. The maximum is 9.");
            }
            return ingredients;
        }
    }
}

