/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.recipe.AbstractNbtTransferringRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class FilmDevelopingRecipe
extends AbstractNbtTransferringRecipe {
    public FilmDevelopingRecipe(ResourceLocation id, Ingredient filmIngredient, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, filmIngredient, ingredients, result);
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Exposure.RecipeSerializers.FILM_DEVELOPING.get();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer container) {
        NonNullList remainingItems = super.m_7457_((Container)container);
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (!(item.m_41720_() instanceof PotionItem)) continue;
            remainingItems.set(i, (Object)new ItemStack((ItemLike)Items.f_42590_));
        }
        return remainingItems;
    }

    public static class Serializer
    implements RecipeSerializer<FilmDevelopingRecipe> {
        @NotNull
        public FilmDevelopingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient filmIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)serializedRecipe, (String)"film"));
            NonNullList<Ingredient> ingredients = this.getIngredients(GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"ingredients"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"result"));
            if (filmIngredient.m_43947_()) {
                throw new JsonParseException("Recipe should have 'film' ingredient.");
            }
            return new FilmDevelopingRecipe(recipeId, filmIngredient, ingredients, result);
        }

        @NotNull
        public FilmDevelopingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient transferredIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ingredientsCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsCount, (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack result = buffer.m_130267_();
            return new FilmDevelopingRecipe(recipeId, transferredIngredient, (NonNullList<Ingredient>)ingredients, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, FilmDevelopingRecipe recipe) {
            recipe.getTransferIngredient().m_43923_(buffer);
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.getResult());
        }

        private NonNullList<Ingredient> getIngredients(JsonArray jsonArray) {
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for a recipe.");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for a recipe. The maximum is 9.");
            }
            return ingredients;
        }
    }
}

