/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record CameraSetSelfieModeC2SP(InteractionHand hand, boolean isInSelfieMode, boolean effects) implements IPacket<CameraSetSelfieModeC2SP>
{
    public static final ResourceLocation ID = Exposure.resource("camera_set_selfie_mode");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.hand);
        buffer.writeBoolean(this.isInSelfieMode);
        buffer.writeBoolean(this.effects);
        return buffer;
    }

    public static CameraSetSelfieModeC2SP fromBuffer(FriendlyByteBuf buffer) {
        return new CameraSetSelfieModeC2SP((InteractionHand)buffer.m_130066_(InteractionHand.class), buffer.readBoolean(), buffer.readBoolean());
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        ItemStack itemInHand = player.m_21120_(this.hand);
        Item item = itemInHand.m_41720_();
        if (!(item instanceof CameraItem)) {
            throw new IllegalStateException("Item in hand in not a Camera.");
        }
        CameraItem cameraItem = (CameraItem)item;
        if (this.effects) {
            cameraItem.setSelfieModeWithEffects(player, itemInHand, this.isInSelfieMode);
        } else {
            cameraItem.setSelfieMode(itemInHand, this.isInSelfieMode);
        }
        return true;
    }
}

