/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.client;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import io.github.mortuusars.exposure.sound.OnePerPlayerSounds;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record StopOnePerPlayerSoundS2CP(UUID sourcePlayerId, SoundEvent soundEvent) implements IPacket<StopOnePerPlayerSoundS2CP>
{
    public static final ResourceLocation ID = Exposure.resource("stop_one_per_player_sound");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.sourcePlayerId);
        buffer.m_130085_(this.soundEvent.m_11660_());
        return buffer;
    }

    public static StopOnePerPlayerSoundS2CP fromBuffer(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        ResourceLocation soundEventLocation = buffer.m_130281_();
        @Nullable SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundEventLocation);
        if (soundEvent == null) {
            soundEvent = (SoundEvent)SoundEvents.f_12209_.m_203334_();
        }
        return new StopOnePerPlayerSoundS2CP(uuid, soundEvent);
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            @Nullable Player sourcePlayer = Minecraft.m_91087_().f_91073_.m_46003_(this.sourcePlayerId);
            if (sourcePlayer != null) {
                Minecraft.m_91087_().execute(() -> OnePerPlayerSounds.stop(sourcePlayer, this.soundEvent));
            } else {
                LogUtils.getLogger().debug("Cannot stop OnePerPlayer sound. SourcePlayer was not found by it's UUID.");
            }
        }
        return true;
    }
}

