/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network;

import com.google.common.base.Preconditions;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.exposure.network.forge.PacketsImpl;
import io.github.mortuusars.exposure.network.packet.IPacket;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;

public class Packets {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToServer(IPacket<?> packet) {
        PacketsImpl.sendToServer(packet);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToClient(IPacket<?> packet, ServerPlayer player) {
        void var1_1;
        PacketsImpl.sendToClient(packet, (ServerPlayer)var1_1);
    }

    public static void sendToClients(IPacket<?> packet, ServerPlayer origin, Predicate<ServerPlayer> filter) {
        Preconditions.checkState((origin.m_20194_() != null ? 1 : 0) != 0, (Object)"Server cannot be null");
        for (ServerPlayer player : origin.m_20194_().m_6846_().m_11314_()) {
            if (!filter.test(player)) continue;
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToOtherClients(IPacket<?> packet, ServerPlayer excludedPlayer) {
        Packets.sendToClients(packet, excludedPlayer, serverPlayer -> !serverPlayer.equals((Object)excludedPlayer));
    }

    public static void sendToOtherClients(IPacket<?> packet, ServerPlayer excludedPlayer, Predicate<ServerPlayer> filter) {
        Packets.sendToClients(packet, excludedPlayer, serverPlayer -> !serverPlayer.equals((Object)excludedPlayer) && filter.test((ServerPlayer)serverPlayer));
    }
}

