/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.component;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographTooltip
implements ClientTooltipComponent,
TooltipComponent {
    public static final int SIZE = 72;
    @Nullable
    private final Either<String, ResourceLocation> idOrTexture;
    private final int photographs;

    public PhotographTooltip(@Nullable Either<String, ResourceLocation> idOrTexture, int photographs) {
        this.idOrTexture = idOrTexture;
        this.photographs = photographs;
    }

    public PhotographTooltip(@Nullable Either<String, ResourceLocation> idOrTexture) {
        this.idOrTexture = idOrTexture;
        this.photographs = 1;
    }

    public int m_142069_(@NotNull Font font) {
        return 72;
    }

    public int m_142103_() {
        return 74;
    }

    public void m_183452_(@NotNull Font font, int mouseX, int mouseY, GuiGraphics guiGraphics) {
        int additionalPhotographs = Math.min(2, this.photographs - 1);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)mouseX, (float)mouseY, 0.0f);
        float scale = 0.28125f;
        float nextPhotographOffset = 0.03125f;
        guiGraphics.m_280168_().m_85841_(scale *= 1.0f - (float)additionalPhotographs * nextPhotographOffset, scale, 1.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        for (int i = additionalPhotographs; i > 0; --i) {
            float posOffset = 256.0f * (nextPhotographOffset * (float)i);
            int brightness = Mth.m_14045_((int)((int)((1.0f - 0.2f * (float)i) * 255.0f)), (int)0, (int)255);
            float rotateOffset = 128.0f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(posOffset, posOffset, 0.0f);
            guiGraphics.m_280168_().m_252880_(rotateOffset, rotateOffset, 0.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)(i * 90 + 90)));
            guiGraphics.m_280168_().m_252880_(-rotateOffset, -rotateOffset, 0.0f);
            ExposureClient.getExposureRenderer().renderPaperTexture(guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, brightness, brightness, brightness, 255);
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.idOrTexture != null) {
            ExposureClient.getExposureRenderer().renderOnPaper(this.idOrTexture, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, 255, 255, 255, 255, false);
        } else {
            ExposureClient.getExposureRenderer().renderPaperTexture(guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, 255, 255, 255, 255);
        }
        bufferSource.m_109911_();
        guiGraphics.m_280168_().m_85849_();
        if (this.photographs > 1) {
            guiGraphics.m_280168_().m_85836_();
            String count = Integer.toString(this.photographs);
            int fontWidth = Minecraft.m_91087_().f_91062_.m_92895_(count);
            float fontScale = 1.6f;
            guiGraphics.m_280168_().m_252880_((float)mouseX + 256.0f * scale - 2.0f - (float)fontWidth * fontScale, (float)mouseY + 256.0f * scale - 2.0f - 8.0f * fontScale, 10.0f);
            guiGraphics.m_280168_().m_85841_(fontScale, fontScale, fontScale);
            guiGraphics.m_280488_(font, count, 0, 0, -1);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

