/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.forge.data.generation.provider;

import com.google.gson.JsonElement;
import io.github.mortuusars.exposure.Exposure;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LootTablesProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator generator;

    public LootTablesProvider(DataGenerator generator) {
        super(generator.getPackOutput(), BuiltInLootTables.m_78766_(), Collections.EMPTY_LIST);
        this.generator = generator;
    }

    @NotNull
    public List<LootTableProvider.SubProviderEntry> getTables() {
        return super.getTables();
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        return CompletableFuture.runAsync(() -> this.dropsSelf(cache, Exposure.Items.LIGHTROOM.get()));
    }

    public LootPoolSingletonContainer.Builder<?> item(ItemLike item, int count) {
        return this.item(item, count, count);
    }

    public LootPoolSingletonContainer.Builder<?> item(ItemLike item, int min, int max) {
        LootPoolSingletonContainer.Builder itemBuilder = LootItem.m_79579_((ItemLike)item);
        if (min == max) {
            itemBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)min)));
        } else {
            itemBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        }
        return itemBuilder;
    }

    private void dropsSelf(CachedOutput cache, BlockItem blockItem) {
        this.writeTable(cache, Exposure.resource("blocks/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)blockItem)).m_135815_()), LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)blockItem))).m_79167_());
    }

    private void writeTable(CachedOutput cache, ResourceLocation location, LootTable lootTable) {
        Path outputFolder = this.generator.getPackOutput().m_245114_();
        Path path = outputFolder.resolve("data/" + location.m_135827_() + "/loot_tables/" + location.m_135815_() + ".json");
        try {
            DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree((Object)lootTable), (Path)path);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't write loot lootTable {}", (Object)path, (Object)e);
        }
    }
}

