/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.forge.data.generation;

import io.github.mortuusars.exposure.forge.data.generation.provider.AdvancementsProvider;
import io.github.mortuusars.exposure.forge.data.generation.provider.BlockTagsProvider;
import io.github.mortuusars.exposure.forge.data.generation.provider.ItemTagsProvider;
import io.github.mortuusars.exposure.forge.data.generation.provider.LootTablesProvider;
import io.github.mortuusars.exposure.forge.data.generation.provider.RecipesProvider;
import io.github.mortuusars.exposure.forge.data.generation.provider.SoundsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="exposure", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementsProvider(generator, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTablesProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipesProvider(generator));
        BlockTagsProvider blockTags = new BlockTagsProvider(generator, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsProvider(generator, provider, blockTags, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new SoundsProvider(generator, helper));
    }
}

