/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.viewfinder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.gui.screen.camera.ViewfinderControlsScreen;
import io.github.mortuusars.exposure.item.FilmRollItem;
import io.github.mortuusars.exposure.util.CameraInHand;
import io.github.mortuusars.exposure.util.GuiUtil;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;

public class ViewfinderOverlay {
    private static final ResourceLocation VIEWFINDER_TEXTURE = Exposure.resource("textures/gui/viewfinder/viewfinder.png");
    public static Rectangle2D.Float opening = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    private static final PoseStack POSE_STACK = new PoseStack();
    private static Minecraft minecraft = Minecraft.m_91087_();
    private static Player player = ViewfinderOverlay.minecraft.f_91074_;
    private static int backgroundColor;
    private static float scale;
    private static Float xRot;
    private static Float yRot;
    private static Float xRot0;
    private static Float yRot0;

    public static void setup() {
        minecraft = Minecraft.m_91087_();
        player = ViewfinderOverlay.minecraft.f_91074_;
        backgroundColor = Config.Client.getBackgroundColor();
        scale = 0.5f;
    }

    public static float getScale() {
        return scale;
    }

    public static void render() {
        Optional<ItemAndStack<FilmRollItem>> film;
        int width = minecraft.m_91268_().m_85445_();
        int height = minecraft.m_91268_().m_85446_();
        scale = Mth.m_14179_((float)Math.min(0.5f * minecraft.m_91297_(), 0.5f), (float)scale, (float)1.0f);
        float openingSize = Math.min(width, height);
        opening = new Rectangle2D.Float(((float)width - openingSize) / 2.0f, ((float)height - openingSize) / 2.0f, openingSize, openingSize);
        if (ViewfinderOverlay.minecraft.f_91066_.f_92062_) {
            return;
        }
        CameraInHand camera = CameraInHand.getActive(player);
        if (camera.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (xRot == null || yRot == null || xRot0 == null || yRot0 == null) {
            xRot = Float.valueOf(player.m_146909_());
            yRot = Float.valueOf(player.m_146908_());
            xRot0 = xRot;
            yRot0 = yRot;
        }
        float delta = Math.min(0.75f * minecraft.m_91297_(), 0.75f);
        xRot0 = Float.valueOf(Mth.m_14179_((float)delta, (float)xRot0.floatValue(), (float)xRot.floatValue()));
        yRot0 = Float.valueOf(Mth.m_14179_((float)delta, (float)yRot0.floatValue(), (float)yRot.floatValue()));
        xRot = Float.valueOf(player.m_146909_());
        yRot = Float.valueOf(player.m_146908_());
        float xDelay = xRot.floatValue() - xRot0.floatValue();
        float yDelay = yRot.floatValue() - yRot0.floatValue();
        PoseStack poseStack = POSE_STACK;
        poseStack.m_85836_();
        poseStack.m_252880_((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        float attackAnim = player.m_21324_(minecraft.m_91296_());
        if (attackAnim > 0.5f) {
            attackAnim = 1.0f - attackAnim;
        }
        poseStack.m_85841_(1.0f - attackAnim * 0.4f, 1.0f - attackAnim * 0.6f, 1.0f - attackAnim * 0.4f);
        poseStack.m_252880_((float)width / 16.0f * attackAnim, (float)width / 5.0f * attackAnim, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)attackAnim, (float)0.0f, (float)10.0f)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)attackAnim, (float)0.0f, (float)100.0f)));
        poseStack.m_252880_((float)(-width) / 2.0f - yDelay, (float)(-height) / 2.0f - xDelay, 0.0f);
        if (((Boolean)ViewfinderOverlay.minecraft.f_91066_.m_231830_().m_231551_()).booleanValue()) {
            ViewfinderOverlay.bobView(poseStack, minecraft.m_91296_());
        }
        ViewfinderOverlay.drawRect(poseStack, -9999.0f, ViewfinderOverlay.opening.y, ViewfinderOverlay.opening.x, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, backgroundColor);
        ViewfinderOverlay.drawRect(poseStack, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width, ViewfinderOverlay.opening.y, width + 9999, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, backgroundColor);
        ViewfinderOverlay.drawRect(poseStack, -9999.0f, -9999.0f, width + 9999, ViewfinderOverlay.opening.y, backgroundColor);
        ViewfinderOverlay.drawRect(poseStack, -9999.0f, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, width + 9999, height + 9999, backgroundColor);
        if (camera.getItem().isShutterOpen(camera.getStack())) {
            ViewfinderOverlay.drawRect(poseStack, ViewfinderOverlay.opening.x, ViewfinderOverlay.opening.y, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, -98624229);
        }
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VIEWFINDER_TEXTURE);
        GuiUtil.blit(poseStack, ViewfinderOverlay.opening.x, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width, ViewfinderOverlay.opening.y, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Exposure.resource("textures/gui/viewfinder/composition_guide/" + camera.getItem().getCompositionGuide(camera.getStack()).getId() + ".png"));
        GuiUtil.blit(poseStack, ViewfinderOverlay.opening.x, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width, ViewfinderOverlay.opening.y, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        if (!(ViewfinderOverlay.minecraft.f_91080_ instanceof ViewfinderControlsScreen || !(film = camera.getItem().getFilm(camera.getStack())).isEmpty() && film.get().getItem().canAddFrame(film.get().getStack()))) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Exposure.resource("textures/gui/viewfinder/icon/no_film.png"));
            float cropFactor = 1.142857f;
            float fromEdge = (ViewfinderOverlay.opening.height - ViewfinderOverlay.opening.height / cropFactor) / 2.0f;
            GuiUtil.blit(poseStack, ViewfinderOverlay.opening.x + ViewfinderOverlay.opening.width / 2.0f - 12.0f, ViewfinderOverlay.opening.y + ViewfinderOverlay.opening.height - (fromEdge / 2.0f + 10.0f), 24.0f, 19.0f, 0, 0, 24, 19, 0.0f);
        }
        poseStack.m_85849_();
    }

    public static void drawRect(PoseStack poseStack, float minX, float minY, float maxX, float maxY, int color) {
        float temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(matrix, minX, maxY, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, maxX, maxY, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, maxX, minY, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, minX, minY, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void bobView(PoseStack poseStack, float partialTicks) {
        Entity entity = minecraft.m_91288_();
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            float f = pl.f_19787_ - pl.f_19867_;
            float f1 = -(pl.f_19787_ + f * partialTicks);
            float f2 = Mth.m_14179_((float)partialTicks, (float)pl.f_36099_, (float)pl.f_36100_);
            poseStack.m_85837_((double)(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 16.0f), (double)(-Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2 * 32.0f)), 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
        }
    }

    static {
        scale = 1.0f;
        xRot = null;
        yRot = null;
        xRot0 = null;
        yRot0 = null;
    }
}

