/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.config.MunitionProperties;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesSerializer;
import rbasamoyai.createbigcannons.munitions.config.PropertiesMunitionEntity;
import rbasamoyai.createbigcannons.network.RootPacket;

public class MunitionPropertiesHandler {
    private static final Map<EntityType<?>, MunitionPropertiesSerializer<?>> ENTITY_TYPE_SERIALIZERS = new HashMap();
    private static final Map<EntityType<?>, MunitionProperties> PROJECTILES = new HashMap();
    private static final Map<Block, MunitionPropertiesSerializer<?>> BLOCK_SERIALIZERS = new HashMap();
    private static final Map<Block, MunitionProperties> BLOCK_PROPELLANT = new HashMap<Block, MunitionProperties>();
    private static final Map<Item, MunitionPropertiesSerializer<?>> ITEM_SERIALIZERS = new HashMap();
    private static final Map<Item, MunitionProperties> ITEM_PROPELLANT = new HashMap<Item, MunitionProperties>();

    public static <T extends MunitionProperties> void registerPropertiesSerializer(EntityType<? extends PropertiesMunitionEntity<T>> type, MunitionPropertiesSerializer<T> ser) {
        if (ENTITY_TYPE_SERIALIZERS.containsKey(type)) {
            throw new IllegalStateException("Serializer for entity type " + BuiltInRegistries.f_256780_.m_7981_(type) + " already registered");
        }
        ENTITY_TYPE_SERIALIZERS.put(type, ser);
    }

    public static <T extends MunitionProperties, B extends Block> void registerPropertiesSerializer(B block, MunitionPropertiesSerializer<T> ser) {
        if (BLOCK_SERIALIZERS.containsKey(block)) {
            throw new IllegalStateException("Serializer for block " + BuiltInRegistries.f_256975_.m_7981_(block) + " already registered");
        }
        BLOCK_SERIALIZERS.put(block, ser);
    }

    public static <T extends MunitionProperties, I extends Item> void registerPropertiesSerializer(I item, MunitionPropertiesSerializer<T> ser) {
        if (ITEM_SERIALIZERS.containsKey(item)) {
            throw new IllegalStateException("Serializer for item " + BuiltInRegistries.f_257033_.m_7981_(item) + " already registered");
        }
        ITEM_SERIALIZERS.put(item, ser);
    }

    @Nullable
    public static MunitionProperties getProperties(EntityType<?> type) {
        return PROJECTILES.get(type);
    }

    @Nullable
    public static MunitionProperties getProperties(Entity entity) {
        return MunitionPropertiesHandler.getProperties(entity.m_6095_());
    }

    @Nullable
    public static MunitionProperties getProperties(Block block) {
        return BLOCK_PROPELLANT.get(block);
    }

    @Nullable
    public static MunitionProperties getProperties(BlockState state) {
        return MunitionPropertiesHandler.getProperties(state.m_60734_());
    }

    @Nullable
    public static MunitionProperties getProperties(Item item) {
        return ITEM_PROPELLANT.get(item);
    }

    @Nullable
    public static MunitionProperties getProperties(ItemStack stack) {
        return MunitionPropertiesHandler.getProperties(stack.m_41720_());
    }

    public static void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(PROJECTILES.size());
        for (Map.Entry<EntityType<?>, MunitionProperties> entry : PROJECTILES.entrySet()) {
            MunitionPropertiesHandler.toNetworkCasted(buf, entry.getKey(), entry.getValue());
        }
        buf.m_130130_(BLOCK_PROPELLANT.size());
        for (Map.Entry<EntityType<?>, MunitionProperties> entry : BLOCK_PROPELLANT.entrySet()) {
            MunitionPropertiesHandler.toNetworkCasted(buf, (Block)entry.getKey(), entry.getValue());
        }
        buf.m_130130_(ITEM_PROPELLANT.size());
        for (Map.Entry<EntityType<?>, MunitionProperties> entry : ITEM_PROPELLANT.entrySet()) {
            MunitionPropertiesHandler.toNetworkCasted(buf, (Item)entry.getKey(), entry.getValue());
        }
    }

    private static <T extends MunitionProperties> void toNetworkCasted(FriendlyByteBuf buf, EntityType<?> type, T properties) {
        buf.m_130070_(BuiltInRegistries.f_256780_.m_7981_(type).toString());
        MunitionPropertiesSerializer<?> ser = ENTITY_TYPE_SERIALIZERS.get(type);
        ser.toNetwork(buf, properties);
    }

    private static <T extends MunitionProperties> void toNetworkCasted(FriendlyByteBuf buf, Block block, T properties) {
        buf.m_130070_(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
        MunitionPropertiesSerializer<?> ser = BLOCK_SERIALIZERS.get(block);
        ser.toNetwork(buf, properties);
    }

    private static <T extends MunitionProperties> void toNetworkCasted(FriendlyByteBuf buf, Item item, T properties) {
        buf.m_130070_(BuiltInRegistries.f_257033_.m_7981_((Object)item).toString());
        MunitionPropertiesSerializer<?> ser = ITEM_SERIALIZERS.get(item);
        ser.toNetwork(buf, properties);
    }

    public static void readBuf(FriendlyByteBuf buf) {
        PROJECTILES.clear();
        int szProj = buf.m_130242_();
        for (int i = 0; i < szProj; ++i) {
            ResourceLocation loc = new ResourceLocation(buf.m_130277_());
            EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(loc);
            MunitionPropertiesSerializer<?> ser = ENTITY_TYPE_SERIALIZERS.get(type);
            PROJECTILES.put((EntityType<?>)type, (MunitionProperties)ser.fromNetwork(loc, buf));
        }
        BLOCK_PROPELLANT.clear();
        int szBlock = buf.m_130242_();
        for (int i = 0; i < szBlock; ++i) {
            ResourceLocation loc = new ResourceLocation(buf.m_130277_());
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(loc);
            MunitionPropertiesSerializer<?> ser = BLOCK_SERIALIZERS.get(block);
            BLOCK_PROPELLANT.put(block, (MunitionProperties)ser.fromNetwork(loc, buf));
        }
        ITEM_PROPELLANT.clear();
        int szItem = buf.m_130242_();
        for (int i = 0; i < szItem; ++i) {
            ResourceLocation loc = new ResourceLocation(buf.m_130277_());
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(loc);
            MunitionPropertiesSerializer<?> ser = ITEM_SERIALIZERS.get(item);
            ITEM_PROPELLANT.put(item, (MunitionProperties)ser.fromNetwork(loc, buf));
        }
    }

    public static void syncTo(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundMunitionPropertiesPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundMunitionPropertiesPacket(), server);
    }

    public record ClientboundMunitionPropertiesPacket(@Nullable FriendlyByteBuf buf) implements RootPacket
    {
        public ClientboundMunitionPropertiesPacket() {
            this(null);
        }

        public static ClientboundMunitionPropertiesPacket copyOf(FriendlyByteBuf buf) {
            return new ClientboundMunitionPropertiesPacket(new FriendlyByteBuf(buf.copy()));
        }

        @Override
        public void rootEncode(FriendlyByteBuf buf) {
            MunitionPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, PacketListener listener, @Nullable ServerPlayer sender) {
            if (this.buf != null) {
                MunitionPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListenerItemPropellant
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerItemPropellant INSTANCE = new ReloadListenerItemPropellant();

        protected ReloadListenerItemPropellant() {
            super(GSON, "munition_properties/item_propellant");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            ITEM_PROPELLANT.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    ResourceLocation loc = entry.getKey();
                    Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(loc).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + loc + "'"));
                    MunitionPropertiesSerializer<?> ser = ITEM_SERIALIZERS.get(item);
                    if (ser == null) {
                        throw new JsonSyntaxException("No configuration for item '" + loc + "' present");
                    }
                    Object properties = ser.fromJson(loc, element.getAsJsonObject());
                    ITEM_PROPELLANT.put(item, (MunitionProperties)properties);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class ReloadListenerBlockPropellant
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerBlockPropellant INSTANCE = new ReloadListenerBlockPropellant();

        protected ReloadListenerBlockPropellant() {
            super(GSON, "munition_properties/block_propellant");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            BLOCK_PROPELLANT.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    ResourceLocation loc = entry.getKey();
                    Block block = (Block)BuiltInRegistries.f_256975_.m_6612_(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    MunitionPropertiesSerializer<?> ser = BLOCK_SERIALIZERS.get(block);
                    if (ser == null) {
                        throw new JsonSyntaxException("No configuration for block '" + loc + "' present");
                    }
                    Object properties = ser.fromJson(loc, element.getAsJsonObject());
                    BLOCK_PROPELLANT.put(block, (MunitionProperties)properties);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class ReloadListenerProjectiles
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListenerProjectiles INSTANCE = new ReloadListenerProjectiles();

        protected ReloadListenerProjectiles() {
            super(GSON, "munition_properties/projectiles");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            PROJECTILES.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    ResourceLocation loc = entry.getKey();
                    EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_6612_(loc).orElseThrow(() -> new JsonSyntaxException("Unknown entity type '" + loc + "'"));
                    MunitionPropertiesSerializer<?> ser = ENTITY_TYPE_SERIALIZERS.get(type);
                    if (ser == null) {
                        throw new JsonSyntaxException("No configuration for entity type '" + loc + "' present");
                    }
                    Object properties = ser.fromJson(loc, element.getAsJsonObject());
                    PROJECTILES.put((EntityType<?>)type, (MunitionProperties)properties);
                }
                catch (Exception exception) {}
            }
        }
    }
}

