/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon.ammo_container;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import rbasamoyai.createbigcannons.index.CBCMenuTypes;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerMenu;

public class AutocannonAmmoContainerItem
extends Item
implements MenuProvider {
    public AutocannonAmmoContainerItem(Item.Properties properties) {
        super(properties);
    }

    public Component m_5446_() {
        return this.m_41466_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return AutocannonAmmoContainerMenu.getServerMenu(i, inventory, player.m_21205_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            if (player.m_36326_()) {
                ItemStack stack = player.m_21120_(hand);
                int spacing = AutocannonAmmoContainerItem.getTracerSpacing(stack);
                CBCMenuTypes.AUTOCANNON_AMMO_CONTAINER.open(splayer, this.m_5446_(), (MenuConstructor)this, buf -> {
                    buf.m_130130_(spacing);
                    buf.m_130055_(new ItemStack((ItemLike)this));
                });
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public static ItemStack getMainAmmoStack(ItemStack container) {
        CompoundTag tag = container.m_41784_();
        return tag.m_128441_("Ammo") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Ammo")) : ItemStack.f_41583_;
    }

    public static ItemStack getTracerAmmoStack(ItemStack container) {
        CompoundTag tag = container.m_41784_();
        return tag.m_128441_("Tracers") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Tracers")) : ItemStack.f_41583_;
    }

    public static int getTracerSpacing(ItemStack container) {
        CompoundTag tag = container.m_41784_();
        return tag.m_128441_("TracerSpacing") ? Mth.m_14045_((int)tag.m_128451_("TracerSpacing"), (int)1, (int)6) : 1;
    }

    public static AutocannonAmmoType getTypeOfContainer(ItemStack container) {
        AutocannonAmmoType type = AutocannonAmmoType.of(AutocannonAmmoContainerItem.getMainAmmoStack(container));
        if (type != AutocannonAmmoType.NONE) {
            return type;
        }
        return AutocannonAmmoType.of(AutocannonAmmoContainerItem.getTracerAmmoStack(container));
    }

    public static int getTotalAmmoCount(ItemStack container) {
        return AutocannonAmmoContainerItem.getMainAmmoStack(container).m_41613_() + AutocannonAmmoContainerItem.getTracerAmmoStack(container).m_41613_();
    }

    public static ItemStack pollItemFromContainer(ItemStack container) {
        if (!(container.m_41720_() instanceof AutocannonAmmoContainerItem)) {
            return ItemStack.f_41583_;
        }
        ItemStack mainAmmo = AutocannonAmmoContainerItem.getMainAmmoStack(container);
        ItemStack tracerAmmo = AutocannonAmmoContainerItem.getTracerAmmoStack(container);
        ItemStack ret = ItemStack.f_41583_;
        if (AutocannonAmmoContainerItem.getTotalAmmoCount(container) % AutocannonAmmoContainerItem.getTracerSpacing(container) == 0) {
            if (!tracerAmmo.m_41619_()) {
                ret = tracerAmmo.m_41620_(1);
                container.m_41784_().m_128365_("Tracers", (Tag)(tracerAmmo.m_41619_() ? new CompoundTag() : tracerAmmo.m_41739_(new CompoundTag())));
            } else if (!mainAmmo.m_41619_()) {
                ret = mainAmmo.m_41620_(1);
                container.m_41784_().m_128365_("Ammo", (Tag)(mainAmmo.m_41619_() ? new CompoundTag() : mainAmmo.m_41739_(new CompoundTag())));
            }
        } else if (!mainAmmo.m_41619_()) {
            ret = mainAmmo.m_41620_(1);
            container.m_41784_().m_128365_("Ammo", (Tag)(mainAmmo.m_41619_() ? new CompoundTag() : mainAmmo.m_41739_(new CompoundTag())));
        } else if (!tracerAmmo.m_41619_()) {
            ret = tracerAmmo.m_41620_(1);
            container.m_41784_().m_128365_("Tracers", (Tag)(tracerAmmo.m_41619_() ? new CompoundTag() : tracerAmmo.m_41739_(new CompoundTag())));
        }
        return ret;
    }
}

