/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCDamageTypes;
import rbasamoyai.createbigcannons.munitions.BaseProjectileProperties;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.PropertiesMunitionEntity;
import rbasamoyai.ritchiesprojectilelib.PreciseProjectile;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;

public abstract class AbstractCannonProjectile<T extends BaseProjectileProperties>
extends Projectile
implements PreciseProjectile,
PropertiesMunitionEntity<T> {
    protected static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(AbstractCannonProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> PROJECTILE_MASS = SynchedEntityData.m_135353_(AbstractCannonProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected int inGroundTime = 0;
    protected float damage;

    protected AbstractCannonProjectile(EntityType<? extends AbstractCannonProjectile> type, Level level) {
        super(type, level);
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        this.damage = properties == null ? 0.0f : properties.entityDamage();
        this.setProjectileMass(properties == null ? 0.0f : properties.durabilityMass());
    }

    public void m_8119_() {
        block8: {
            Vec3 vel;
            ServerLevel slevel;
            block11: {
                Vec3 uel;
                block9: {
                    block10: {
                        ChunkPos cpos = new ChunkPos(this.m_20183_());
                        if (!this.m_9236_().f_46443_ && !this.m_9236_().m_7232_(cpos.f_45578_, cpos.f_45579_)) break block8;
                        Level level = this.m_9236_();
                        if (level instanceof ServerLevel) {
                            slevel = (ServerLevel)level;
                            if (((Boolean)CBCConfigs.SERVER.munitions.projectilesCanChunkload.get()).booleanValue()) {
                                RitchiesProjectileLib.queueForceLoad((ServerLevel)slevel, (Entity)this, (int)cpos.f_45578_, (int)cpos.f_45579_, (boolean)false);
                            }
                        }
                        super.m_8119_();
                        if (!this.isInGround()) {
                            this.clipAndDamage();
                        }
                        this.onTickRotate();
                        if (!this.isInGround()) break block9;
                        this.m_20256_(Vec3.f_82478_);
                        if (!this.shouldFall()) break block10;
                        this.setInGround(false);
                        break block11;
                    }
                    if (this.m_9236_().f_46443_) break block11;
                    ++this.inGroundTime;
                    if (this.inGroundTime != 400) break block11;
                    this.m_146870_();
                    break block11;
                }
                this.inGroundTime = 0;
                vel = uel = this.m_20184_();
                Vec3 oldPos = this.m_20182_();
                Vec3 newPos = oldPos.m_82549_(vel);
                if (!this.m_20068_()) {
                    vel = vel.m_82520_(0.0, this.getGravity(), 0.0);
                }
                vel = vel.m_82490_(this.getDrag());
                this.m_20256_(vel);
                Vec3 position = newPos.m_82549_(vel.m_82546_(uel).m_82490_(0.5));
                this.m_146884_(position);
                ParticleOptions particle = this.getTrailParticles();
                if (particle != null) {
                    for (int i = 0; i < 10; ++i) {
                        double partial = (float)i * 0.1f;
                        double dx = Mth.m_14139_((double)partial, (double)this.f_19790_, (double)this.m_20185_());
                        double dy = Mth.m_14139_((double)partial, (double)this.f_19791_, (double)this.m_20186_());
                        double dz = Mth.m_14139_((double)partial, (double)this.f_19792_, (double)this.m_20189_());
                        this.m_9236_().m_7106_(particle, dx, dy, dz, 0.0, 0.0, 0.0);
                    }
                }
            }
            vel = this.m_9236_();
            if (vel instanceof ServerLevel) {
                slevel = (ServerLevel)vel;
                if (!this.m_213877_() && ((Boolean)CBCConfigs.SERVER.munitions.projectilesCanChunkload.get()).booleanValue()) {
                    ChunkPos cpos1 = new ChunkPos(this.m_20183_());
                    RitchiesProjectileLib.queueForceLoad((ServerLevel)slevel, (Entity)this, (int)cpos1.f_45578_, (int)cpos1.f_45579_, (boolean)true);
                }
            }
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            RitchiesProjectileLib.removeAllForceLoaded((ServerLevel)slevel, (Entity)this);
        }
        super.m_142687_(reason);
    }

    protected void onTickRotate() {
    }

    protected void clipAndDamage() {
        Vec3 pos;
        ProjectileContext projCtx = new ProjectileContext(this, (CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get()));
        Vec3 start = pos = this.m_20182_();
        double reach = (double)Math.max(this.m_20205_(), this.m_20206_()) * 0.5;
        double t = 1.0;
        int MAX_ITER = 100;
        for (int p = 0; p < MAX_ITER; ++p) {
            boolean breakEarly = false;
            Vec3 vel = this.m_20184_().m_82490_(t);
            if (vel.m_82556_() < 1.0E-4) break;
            Vec3 end = start.m_82549_(vel);
            BlockHitResult bResult = this.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (bResult.m_6662_() != HitResult.Type.MISS) {
                end = bResult.m_82450_();
            }
            AABB currentMovementRegion = this.m_20191_().m_82369_(end.m_82546_(start)).m_82400_(1.0).m_82383_(start.m_82546_(pos));
            Vec3 finalStart = start;
            Vec3 finalEnd = end;
            AABB thisBB = this.m_20191_();
            for (Entity target : this.m_9236_().m_6249_((Entity)this, currentMovementRegion, e -> {
                if (projCtx.hasHitEntity((Entity)e) || !this.m_5603_((Entity)e)) {
                    return false;
                }
                AABB bb = e.m_20191_();
                return bb.m_82381_(thisBB) || bb.m_82400_(reach).m_82371_(finalStart, finalEnd).isPresent();
            })) {
                projCtx.addEntity(target);
            }
            Vec3 hitLoc = end;
            if (bResult.m_6662_() != HitResult.Type.MISS) {
                BlockPos bpos = bResult.m_82425_().m_7949_();
                BlockState state = this.m_9236_().m_46745_(bpos).m_8055_(bpos);
                Vec3 curVel = this.m_20184_();
                double mag = curVel.m_82553_();
                boolean flag1 = projCtx.getLastState().m_60795_();
                if (!flag1 || !this.tryBounceOffBlock(state, bResult)) {
                    projCtx.setLastState(state);
                    double startMass = this.getProjectileMass();
                    double curPom = startMass * mag;
                    double hardness = BlockHardnessHandler.getHardness(state);
                    if (projCtx.griefState() == CBCCfgMunitions.GriefState.NO_DAMAGE || state.m_60800_((BlockGetter)this.m_9236_(), bpos) == -1.0f || curPom < hardness) {
                        this.setInGround(true);
                        this.m_20256_(Vec3.f_82478_);
                        this.onImpact((HitResult)bResult, true);
                        breakEarly = true;
                    } else {
                        state.m_60669_(this.m_9236_(), state, bResult, (Projectile)this);
                        this.onDestroyBlock(state, bResult);
                        if (this.m_213877_()) {
                            breakEarly = true;
                        } else {
                            this.onImpact((HitResult)bResult, false);
                            if (this.m_213877_()) {
                                breakEarly = true;
                            } else {
                                double f = this.overPenetrationPower(hardness, curPom);
                                if (flag1 && f > 0.0) {
                                    projCtx.queueExplosion(bpos, (float)f);
                                }
                            }
                        }
                    }
                }
            }
            Vec3 disp = hitLoc.m_82546_(start);
            start = hitLoc;
            if (this.onClip(projCtx, start) || breakEarly || (t -= disp.m_82553_() / vel.m_82553_()) < 0.0) break;
        }
        for (Entity e2 : projCtx.hitEntities()) {
            this.onHitEntity(e2);
        }
        if (!this.m_9236_().f_46443_ && projCtx.griefState() != CBCCfgMunitions.GriefState.NO_DAMAGE) {
            Vec3 oldVel = this.m_20184_();
            for (Map.Entry<BlockPos, Float> explosion : projCtx.getQueuedExplosions().entrySet()) {
                BlockPos bpos = explosion.getKey();
                this.m_9236_().m_254849_((Entity)this, (double)bpos.m_123341_() + 0.5, (double)bpos.m_123342_() + 0.5, (double)bpos.m_123343_() + 0.5, explosion.getValue().floatValue(), Level.ExplosionInteraction.BLOCK);
            }
            this.m_20256_(oldVel);
        }
    }

    protected boolean onClip(ProjectileContext ctx, Vec3 pos) {
        return false;
    }

    protected double overPenetrationPower(double hardness, double curPom) {
        double f = hardness / curPom;
        return f <= 0.15 ? 2.0 - 2.0 * f : 0.0;
    }

    protected boolean tryBounceOffBlock(BlockState state, BlockHitResult result) {
        BounceType bounce = this.canBounce(state, result);
        if (bounce == BounceType.NO_BOUNCE) {
            return false;
        }
        Vec3 oldVel = this.m_20184_();
        double momentum = (double)this.getProjectileMass() * oldVel.m_82553_();
        if (bounce == BounceType.DEFLECT) {
            if (momentum > BlockHardnessHandler.getHardness(state) * 0.5) {
                Vec3 spallLoc = this.m_20182_().m_82549_(oldVel.m_82541_().m_82490_(2.0));
                this.m_9236_().m_254849_(null, spallLoc.f_82479_, spallLoc.f_82480_, spallLoc.f_82481_, 2.0f, Level.ExplosionInteraction.NONE);
            }
            SoundType sound = state.m_60827_();
            this.m_5496_(sound.m_56775_(), sound.m_56773_(), sound.m_56774_());
        }
        Vec3 normal = new Vec3(result.m_82434_().m_253071_());
        double elasticity = bounce == BounceType.RICOCHET ? 1.5 : 1.9;
        this.m_20256_(oldVel.m_82546_(normal.m_82490_(normal.m_82526_(oldVel) * elasticity)));
        return true;
    }

    protected void onImpact(HitResult result, boolean stopped) {
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockState state = this.m_9236_().m_8055_(((BlockHitResult)result).m_82425_());
            state.m_60669_(this.m_9236_(), state, (BlockHitResult)result, (Projectile)this);
        }
    }

    protected abstract void onDestroyBlock(BlockState var1, BlockHitResult var2);

    protected void onHitEntity(Entity entity) {
        if (this.getProjectileMass() <= 0.0f) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
            entity.m_20256_(this.m_20184_().m_82490_((double)this.getKnockback(entity)));
            DamageSource source = this.getEntityDamage(entity);
            if (properties == null || properties.ignoresEntityArmor()) {
                entity.f_19802_ = 0;
            }
            entity.m_6469_(source, this.damage);
            if (properties == null || !properties.rendersInvulnerable()) {
                entity.f_19802_ = 0;
            }
            double penalty = entity.m_6084_() ? 2.0 : 0.2;
            this.setProjectileMass((float)Math.max((double)this.getProjectileMass() - penalty, 0.0));
            this.onImpact((HitResult)new EntityHitResult(entity), this.getProjectileMass() <= 0.0f);
        }
    }

    protected DamageSource getEntityDamage(Entity entity) {
        return this.indirectArtilleryFire();
    }

    protected float getKnockback(Entity target) {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        return properties == null ? 0.0f : properties.knockback();
    }

    protected boolean canDeflect(BlockHitResult result) {
        return false;
    }

    protected boolean canBounceOffOf(BlockState state) {
        return AbstractCannonProjectile.isBounceableOffOf(state);
    }

    public static boolean isDeflector(BlockState state) {
        return state.m_204336_(CBCTags.CBCBlockTags.DEFLECTS_SHOTS);
    }

    public static boolean isBounceableOffOf(BlockState state) {
        return state.m_204336_(CBCTags.CBCBlockTags.BOUNCES_SHOTS);
    }

    protected BounceType canBounce(BlockState state, BlockHitResult result) {
        if (!((Boolean)CBCConfigs.SERVER.munitions.projectilesCanBounce.get()).booleanValue() || this.getProjectileMass() <= 0.0f) {
            return BounceType.NO_BOUNCE;
        }
        if (!this.canBounceOffOf(state)) {
            return BounceType.NO_BOUNCE;
        }
        Vec3 oldVel = this.m_20184_();
        double mag = oldVel.m_82553_();
        if (mag < 0.2) {
            return BounceType.NO_BOUNCE;
        }
        Vec3 normal = new Vec3(result.m_82434_().m_253071_());
        double fc = normal.m_82526_(oldVel) / mag;
        if (this.canDeflect(result) && -1.0 <= fc && fc <= -0.5) {
            return BounceType.DEFLECT;
        }
        return -0.5 <= fc && fc <= 0.0 ? BounceType.RICOCHET : BounceType.NO_BOUNCE;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(PROJECTILE_MASS, (Object)Float.valueOf(0.0f));
    }

    public void setInGround(boolean inGround) {
        if (inGround) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) | 1)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 0xFE)));
        }
    }

    public boolean isInGround() {
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 1) != 0;
    }

    private boolean shouldFall() {
        return this.isInGround() && this.m_9236_().m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    @Nullable
    protected ParticleOptions getTrailParticles() {
        return null;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ProjectileMass", this.getProjectileMass());
        tag.m_128379_("InGround", this.isInGround());
        tag.m_128350_("Damage", this.damage);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setProjectileMass(tag.m_128457_("ProjectileMass"));
        this.setInGround(tag.m_128471_("InGround"));
        this.damage = tag.m_128457_("Damage");
    }

    public void setProjectileMass(float power) {
        this.f_19804_.m_135381_(PROJECTILE_MASS, (Object)Float.valueOf(power));
    }

    public float getProjectileMass() {
        return ((Float)this.f_19804_.m_135370_(PROJECTILE_MASS)).floatValue();
    }

    public static void build(EntityType.Builder<? extends AbstractCannonProjectile<?>> builder) {
        builder.m_20702_(16).m_20717_(1).m_20719_().m_20699_(0.8f, 0.8f);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    protected double getGravity() {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        double val = properties == null ? -0.05 : properties.gravity();
        double multiplier = DimensionMunitionPropertiesHandler.getProperties(this.m_9236_()).gravityMultiplier();
        return val * multiplier;
    }

    protected double getDrag() {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        float baseDrag = properties == null ? 0.99f : (float)properties.drag();
        float scalar = (float)DimensionMunitionPropertiesHandler.getProperties(this.m_9236_()).dragMultiplier();
        if (scalar <= 1.0f) {
            return Mth.m_14179_((float)scalar, (float)1.0f, (float)baseDrag);
        }
        float diff = baseDrag - 1.0f;
        return (float)Mth.m_14008_((double)(baseDrag + diff * (scalar - 1.0f)), (double)0.9, (double)baseDrag);
    }

    public void setChargePower(float power) {
    }

    public boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && !(entity instanceof Projectile);
    }

    public DamageSource indirectArtilleryFire() {
        return new CannonDamageSource((Holder<DamageType>)CannonDamageSource.getDamageRegistry(this.m_9236_()).m_246971_(CBCDamageTypes.CANNON_PROJECTILE), (Entity)this);
    }

    public static enum BounceType {
        DEFLECT,
        RICOCHET,
        NO_BOUNCE;

    }
}

