/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge;

import com.simibubi.create.content.kinetics.deployer.DeployerRecipeSearchEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import rbasamoyai.createbigcannons.base.CBCCommonEvents;
import rbasamoyai.createbigcannons.crafting.welding.CannonWelderItem;

public class CBCCommonForgeEvents {
    public static void register(IEventBus forgeEventBus) {
        forgeEventBus.addListener(CBCCommonForgeEvents::onPlayerBreakBlock);
        forgeEventBus.addListener(CBCCommonForgeEvents::onPlayerLogin);
        forgeEventBus.addListener(CBCCommonForgeEvents::onPlayerLogout);
        forgeEventBus.addListener(CBCCommonForgeEvents::onLoadWorld);
        forgeEventBus.addListener(CBCCommonForgeEvents::onServerWorldTick);
        forgeEventBus.addListener(CBCCommonForgeEvents::onDatapackSync);
        forgeEventBus.addListener(CBCCommonForgeEvents::onAddReloadListeners);
        forgeEventBus.addListener(CBCCommonForgeEvents::onDeployerRecipeSearch);
        forgeEventBus.addListener(CBCCommonForgeEvents::onUseItemOnBlock);
    }

    public static void onServerWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (evt.side == LogicalSide.CLIENT) {
            return;
        }
        CBCCommonEvents.serverLevelTickEnd(evt.level);
    }

    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        CBCCommonEvents.onPlayerBreakBlock(event.getState(), event.getLevel(), event.getPos(), event.getPlayer());
    }

    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CBCCommonEvents.onPlayerLogin(player2);
        }
    }

    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent evt) {
        CBCCommonEvents.onPlayerLogout(evt.getEntity());
    }

    public static void onLoadWorld(LevelEvent.Load evt) {
        CBCCommonEvents.onLoadLevel(evt.getLevel());
    }

    public static void onDatapackSync(OnDatapackSyncEvent evt) {
        if (evt.getPlayer() == null) {
            CBCCommonEvents.onDatapackReload(evt.getPlayerList().m_7873_());
        } else {
            CBCCommonEvents.onDatapackSync(evt.getPlayer());
        }
    }

    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        CBCCommonEvents.onAddReloadListeners((PreparableReloadListener m, ResourceLocation l) -> event.addListener(m));
    }

    public static void onDeployerRecipeSearch(DeployerRecipeSearchEvent evt) {
        CBCCommonEvents.onAddDeployerRecipes(evt.getBlockEntity(), (Container)evt.getInventory(), (arg_0, arg_1) -> ((DeployerRecipeSearchEvent)evt).addRecipe(arg_0, arg_1));
    }

    public static void onUseItemOnBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().m_41720_() instanceof CannonWelderItem && CannonWelderItem.welderItemAlwaysPlacesWhenUsed(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec()) == InteractionResult.FAIL) {
            event.setUseBlock(Event.Result.DENY);
        }
    }
}

