/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.material.BigCannonMaterial;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeFinder;
import rbasamoyai.createbigcannons.crafting.WandActionable;
import rbasamoyai.createbigcannons.crafting.builtup.BuiltUpHeatingRecipe;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.index.CBCBigCannonMaterials;
import rbasamoyai.createbigcannons.index.CBCBlockEntities;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;

public class LayeredBigCannonBlockEntity
extends SmartBlockEntity
implements IBigCannonBlockEntity,
WandActionable {
    private static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final Object BUILT_UP_HEATING_RECIPES_KEY = new Object();
    private BigCannonBehavior cannonBehavior;
    private BigCannonMaterial baseMaterial;
    private Map<CannonCastShape, Block> layeredBlocks = new HashMap<CannonCastShape, Block>();
    private Multimap<Direction, CannonCastShape> layersConnectedTowards = HashMultimap.create();
    private Direction currentFacing;
    private TransportedItemStack clockStack = new TransportedItemStack(ItemStack.f_41583_);
    private int completionProgress;

    public LayeredBigCannonBlockEntity(BlockEntityType<? extends LayeredBigCannonBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (state.m_61138_((Property)FACING)) {
            this.currentFacing = (Direction)state.m_61143_((Property)FACING);
        }
    }

    @Override
    public BigCannonBehavior cannonBehavior() {
        return this.cannonBehavior;
    }

    public void setBaseMaterial(BigCannonMaterial material) {
        this.baseMaterial = material;
    }

    public BigCannonMaterial getBaseMaterial() {
        return this.baseMaterial;
    }

    public void tick() {
        super.tick();
        BlockState state = this.m_58900_();
        if (!this.m_58904_().f_46443_ && this.isEmpty()) {
            this.m_7651_();
            this.m_58904_().m_7731_(this.f_58858_, Blocks.f_50016_.m_49966_(), 19);
            return;
        }
        if (state.m_61138_((Property)FACING)) {
            Direction previousFacing = this.currentFacing;
            this.currentFacing = (Direction)state.m_61143_((Property)FACING);
            if (previousFacing != null && previousFacing != this.currentFacing) {
                Direction.Axis rotationAxis = LayeredBigCannonBlockEntity.getRotationAxis(previousFacing, this.currentFacing);
                Rotation rotation = LayeredBigCannonBlockEntity.getRotationBetween(previousFacing, this.currentFacing, rotationAxis);
                HashMultimap newLayersConnected = HashMultimap.create();
                Iterator iterator = this.layersConnectedTowards.keySet().iterator();
                while (iterator.hasNext()) {
                    Direction dir;
                    Direction dc = dir = (Direction)iterator.next();
                    for (int i = 0; i < rotation.ordinal(); ++i) {
                        dc = dc.m_175362_(rotationAxis);
                    }
                    newLayersConnected.putAll((Object)dc, (Iterable)this.layersConnectedTowards.get((Object)dir));
                }
                this.layersConnectedTowards = newLayersConnected;
                this.m_6596_();
            }
        }
        if (!this.m_58904_().f_46443_) {
            if (IndexPlatform.layeredCannonClockStackCheck(this.clockStack)) {
                IndexPlatform.layeredCannonClockStackCallback(this.clockStack);
                this.clockStack.processingTime = -1;
                ++this.completionProgress;
                this.sendData();
                int cap = (Integer)CBCConfigs.SERVER.crafting.builtUpCannonHeatingTime.get();
                if (this.completionProgress >= cap) {
                    this.completionProgress = cap;
                    if (!this.tryFinishHeating()) {
                        this.completionProgress = 0;
                    }
                }
            } else if (this.completionProgress > 0) {
                --this.completionProgress;
                this.sendData();
            }
        }
    }

    private boolean tryFinishHeating() {
        List<BlockRecipe> recipes = BlockRecipeFinder.get(BUILT_UP_HEATING_RECIPES_KEY, this.m_58904_(), this::matchingRecipeCache);
        if (recipes.isEmpty()) {
            return false;
        }
        Optional<BlockRecipe> recipe = recipes.stream().filter(r -> r.matches(this.m_58904_(), this.f_58858_)).findFirst();
        if (!recipe.isPresent()) {
            return false;
        }
        recipe.get().assembleInWorld(this.m_58904_(), this.f_58858_);
        return true;
    }

    @Override
    public InteractionResult onWandUsed(UseOnContext context) {
        if (!this.m_58904_().f_46443_) {
            this.tryFinishHeating();
        }
        return InteractionResult.m_19078_((boolean)this.m_58904_().f_46443_);
    }

    private boolean matchingRecipeCache(BlockRecipe recipe) {
        return recipe instanceof BuiltUpHeatingRecipe;
    }

    private static Direction.Axis getRotationAxis(Direction prev, Direction current) {
        EnumSet<Direction.Axis> axes = EnumSet.allOf(Direction.Axis.class);
        axes.remove(prev.m_122434_());
        axes.remove(current.m_122434_());
        return (Direction.Axis)axes.stream().findFirst().orElseThrow(() -> new IllegalStateException("Failed to find the rotation axes of two different axes"));
    }

    private static Rotation getRotationBetween(Direction prev, Direction current, Direction.Axis axis) {
        if (prev == current) {
            return Rotation.NONE;
        }
        if (prev == current.m_122424_()) {
            return Rotation.CLOCKWISE_180;
        }
        return prev.m_175362_(axis) == current ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
    }

    public void setLayer(CannonCastShape layer, Block block) {
        this.layeredBlocks.put(layer, block);
    }

    public Block getLayer(CannonCastShape layer) {
        return this.layeredBlocks.get(layer);
    }

    public void removeLayer(CannonCastShape layer) {
        this.layeredBlocks.remove(layer);
        for (Direction dir : Iterate.directions) {
            this.setLayerConnectedTo(dir, layer, false);
        }
    }

    public boolean hasLayer(CannonCastShape layer) {
        return this.layeredBlocks.containsKey(layer);
    }

    public Map<CannonCastShape, Block> getLayers() {
        return this.layeredBlocks;
    }

    public CannonCastShape getTopCannonShape() {
        if (this.layeredBlocks.isEmpty()) {
            return null;
        }
        CannonCastShape result = null;
        for (CannonCastShape shape : this.layeredBlocks.keySet()) {
            if (result != null && result.diameter() >= shape.diameter()) continue;
            result = shape;
        }
        return result;
    }

    public CannonCastShape getTopConnectedLayer(Direction direction) {
        if (!this.layersConnectedTowards.containsKey((Object)direction)) {
            return null;
        }
        CannonCastShape result = null;
        for (CannonCastShape shape : this.layersConnectedTowards.get((Object)direction)) {
            if (result != null && result.diameter() >= shape.diameter()) continue;
            result = shape;
        }
        return result;
    }

    public LayeredBigCannonBlockEntity getSplitBlockEntity(Collection<CannonCastShape> layers, Direction from) {
        LayeredBigCannonBlockEntity newLayer = new LayeredBigCannonBlockEntity((BlockEntityType<? extends LayeredBigCannonBlockEntity>)((BlockEntityType)CBCBlockEntities.LAYERED_CANNON.get()), this.f_58858_, this.m_58900_());
        newLayer.baseMaterial = this.baseMaterial;
        newLayer.currentFacing = this.currentFacing;
        for (CannonCastShape layer : layers) {
            if (!this.layeredBlocks.containsKey(layer) || from != null && !this.isLayerConnectedTo(from, layer)) continue;
            newLayer.setLayer(layer, this.getLayer(layer));
            for (Direction dir : Iterate.directions) {
                newLayer.setLayerConnectedTo(dir, layer, this.isLayerConnectedTo(dir, layer));
            }
        }
        for (Direction dir : Iterate.directions) {
            boolean connect = this.cannonBehavior.isConnectedTo(dir);
            newLayer.cannonBehavior.setConnectedFace(dir, connect);
        }
        return newLayer;
    }

    public LayeredBigCannonBlockEntity getSplitBlockEntity(CannonCastShape fullShape, Direction from) {
        return this.getSplitBlockEntity(Arrays.asList(fullShape), from);
    }

    public void removeLayersOfOther(LayeredBigCannonBlockEntity other) {
        for (CannonCastShape layer : other.layeredBlocks.keySet()) {
            this.removeLayer(layer);
        }
    }

    public void addLayersOfOther(LayeredBigCannonBlockEntity other) {
        for (Map.Entry<CannonCastShape, Block> layer : other.layeredBlocks.entrySet()) {
            CannonCastShape shape = layer.getKey();
            this.setLayer(shape, layer.getValue());
            for (Direction dir : Iterate.directions) {
                this.setLayerConnectedTo(dir, shape, other.isLayerConnectedTo(dir, shape));
            }
        }
        this.m_6596_();
    }

    public Block getSimplifiedBlock() {
        return this.isEmpty() ? Blocks.f_50016_ : (this.layeredBlocks.size() == 1 ? this.layeredBlocks.values().stream().findAny().get() : (Block)CBCBlocks.BUILT_UP_CANNON.get());
    }

    public void updateBlockstate() {
        Block block = this.getSimplifiedBlock();
        if (this.m_58900_().m_60734_() != block) {
            BlockState newState = block.m_49966_();
            if (newState.m_61138_((Property)FACING) && this.m_58900_().m_61138_((Property)FACING)) {
                newState = (BlockState)newState.m_61124_((Property)FACING, (Comparable)((Direction)this.m_58900_().m_61143_((Property)FACING)));
            }
            this.m_7651_();
            this.m_58904_().m_7731_(this.f_58858_, newState, 19);
            if (!this.m_58903_().m_155262_(newState)) {
                return;
            }
            BlockEntity be = this.m_58904_().m_7702_(this.f_58858_);
            if (!(be instanceof LayeredBigCannonBlockEntity)) {
                return;
            }
            LayeredBigCannonBlockEntity newLayered = (LayeredBigCannonBlockEntity)be;
            newLayered.layeredBlocks = this.layeredBlocks;
            newLayered.layersConnectedTowards = this.layersConnectedTowards;
            newLayered.baseMaterial = this.baseMaterial;
            newLayered.currentFacing = (Direction)newState.m_61143_((Property)FACING);
            newLayered.m_6596_();
            for (Direction dir : Iterate.directions) {
                BlockPos pos1 = newLayered.f_58858_.m_121945_(dir);
                BlockEntity be1 = newLayered.f_58857_.m_7702_(pos1);
                BlockState state1 = newLayered.f_58857_.m_8055_(pos1);
                if (be1 instanceof ICannonBlockEntity) {
                    BigCannonBlock cBlock;
                    ICannonBlockEntity cbe = (ICannonBlockEntity)be1;
                    Block block2 = state1.m_60734_();
                    if (block2 instanceof BigCannonBlock && (cBlock = (BigCannonBlock)block2).getCannonMaterialInLevel((LevelAccessor)newLayered.f_58857_, state1, pos1) == newLayered.baseMaterial) {
                        boolean connect = this.cannonBehavior.isConnectedTo(dir);
                        newLayered.cannonBehavior.setConnectedFace(dir, connect);
                        ((CannonBehavior)((Object)cbe.cannonBehavior())).setConnectedFace(dir.m_122424_(), connect);
                    }
                }
                if (!(be1 instanceof LayeredBigCannonBlockEntity)) continue;
                LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)be1;
                if (layered1.baseMaterial != this.baseMaterial) continue;
                for (CannonCastShape shape : this.getConnectedTo(dir)) {
                    layered1.setLayerConnectedTo(dir.m_122424_(), shape, true);
                }
                layered1.m_6596_();
            }
        }
    }

    public void setLayerConnectedTo(Direction direction, CannonCastShape shape, boolean connected) {
        if (!this.layeredBlocks.containsKey(shape)) {
            return;
        }
        if (connected) {
            this.layersConnectedTowards.put((Object)direction, (Object)shape);
        } else {
            this.layersConnectedTowards.remove((Object)direction, (Object)shape);
        }
    }

    public boolean isLayerConnectedTo(Direction direction, CannonCastShape shape) {
        return this.layersConnectedTowards.get((Object)direction).contains(shape);
    }

    public boolean isEmpty() {
        return this.layeredBlocks.isEmpty();
    }

    public Collection<CannonCastShape> getConnectedTo(Direction direction) {
        return this.layersConnectedTowards.get((Object)direction);
    }

    public boolean isCollidingWith(StructureTemplate.StructureBlockInfo info, LayeredBigCannonBlockEntity other, Direction dir) {
        if (this.currentFacing == null || dir.m_122434_() != this.currentFacing.m_122434_()) {
            return true;
        }
        if (info.f_74677_() == null || !info.f_74677_().m_128441_("id")) {
            return true;
        }
        if (other.baseMaterial != this.baseMaterial) {
            return true;
        }
        Set set = this.layeredBlocks.keySet().stream().map(CannonCastShape::diameter).collect(Collectors.toCollection(HashSet::new));
        Set set1 = other.layeredBlocks.keySet().stream().map(CannonCastShape::diameter).collect(Collectors.toCollection(HashSet::new));
        set.retainAll(set1);
        return !set.isEmpty();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.cannonBehavior = new BigCannonBehavior(this, this::canLoadBlock);
        behaviours.add(this.cannonBehavior);
        behaviours.add((BlockEntityBehaviour)new TransportedItemStackHandlerBehaviour((SmartBlockEntity)this, this::clockCallback));
    }

    private void clockCallback(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> func) {
        func.apply(this.clockStack);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.baseMaterial != null) {
            tag.m_128359_("Material", this.baseMaterial.name().toString());
        }
        ListTag layerTag = new ListTag();
        Registry<CannonCastShape> cannonCastShapeRegistry = CBCRegistries.cannonCastShapes();
        for (Map.Entry<CannonCastShape, Block> e : this.layeredBlocks.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("Shape", cannonCastShapeRegistry.m_7981_((Object)e.getKey()).toString());
            entryTag.m_128359_("Block", BuiltInRegistries.f_256975_.m_7981_((Object)e.getValue()).toString());
            layerTag.add((Object)entryTag);
        }
        tag.m_128365_("Layers", (Tag)layerTag);
        CompoundTag layerConnectionTag = new CompoundTag();
        for (Direction dir : Iterate.directions) {
            if (!this.layersConnectedTowards.containsKey((Object)dir)) continue;
            layerConnectionTag.m_128365_(dir.m_7912_(), (Tag)this.layersConnectedTowards.get((Object)dir).stream().map(arg_0 -> cannonCastShapeRegistry.m_7981_(arg_0)).map(ResourceLocation::toString).map(StringTag::m_129297_).collect(Collectors.toCollection(ListTag::new)));
        }
        tag.m_128365_("LayerConnections", (Tag)layerConnectionTag);
        if (this.currentFacing != null) {
            tag.m_128359_("Facing", this.currentFacing.m_7912_());
        }
        if (this.completionProgress > 0) {
            tag.m_128405_("Progress", this.completionProgress);
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        boolean justBored = tag.m_128441_("JustBored");
        this.layersConnectedTowards.clear();
        CompoundTag layerConnectionTag = tag.m_128469_("LayerConnections");
        Registry<CannonCastShape> cannonCastShapeRegistry = CBCRegistries.cannonCastShapes();
        for (Direction dir : Iterate.directions) {
            if (!layerConnectionTag.m_128441_(dir.m_7912_())) continue;
            ListTag connections = layerConnectionTag.m_128437_(dir.m_7912_(), 8);
            for (int i = 0; i < connections.size(); ++i) {
                CannonCastShape shape = (CannonCastShape)cannonCastShapeRegistry.m_7745_(new ResourceLocation(connections.m_128778_(i)));
                if (shape == null) continue;
                this.layersConnectedTowards.put((Object)dir, (Object)shape);
            }
        }
        if (justBored) {
            tag.m_128473_("JustBored");
            return;
        }
        BigCannonMaterial bigCannonMaterial = this.baseMaterial = tag.m_128441_("Material") ? BigCannonMaterial.fromNameOrNull(new ResourceLocation(tag.m_128461_("Material"))) : null;
        if (this.baseMaterial == null) {
            this.baseMaterial = CBCBigCannonMaterials.STEEL;
        }
        this.layeredBlocks.clear();
        ListTag layers = tag.m_128437_("Layers", 10);
        for (int i = 0; i < layers.size(); ++i) {
            CompoundTag entry = layers.m_128728_(i);
            this.layeredBlocks.put((CannonCastShape)cannonCastShapeRegistry.m_7745_(new ResourceLocation(entry.m_128461_("Shape"))), (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(entry.m_128461_("Block"))));
        }
        this.currentFacing = tag.m_128441_("Facing") ? Direction.m_122402_((String)tag.m_128461_("Facing")) : null;
        this.completionProgress = tag.m_128451_("Progress");
    }

    @Override
    public boolean canLoadBlock(StructureTemplate.StructureBlockInfo blockInfo) {
        return false;
    }
}

