/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockEntities;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class CannonBuilderBlock
extends DirectionalAxisKineticBlock
implements IBE<CannonBuilderBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<BuilderState> STATE = EnumProperty.m_61587_((String)"state", BuilderState.class);

    public CannonBuilderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(STATE, (Comparable)((Object)BuilderState.UNACTIVATED)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{STATE});
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState cState;
        BlockPos cPos;
        int i;
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos headPos = null;
        boolean dropBlocks = player == null || !player.m_7500_();
        int max = CannonBuilderBlock.maxAllowedBuilderLength();
        for (i = 1; i <= max; ++i) {
            cPos = pos.m_5484_(dir, i);
            cState = level.m_8055_(cPos);
            if (AllBlocks.PISTON_EXTENSION_POLE.has(cState) && dir.m_122434_() == ((Direction)cState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) continue;
            if (!CBCBlocks.CANNON_BUILDER_HEAD.has(cState) || dir != cState.m_61143_((Property)BlockStateProperties.f_61372_)) break;
            headPos = cPos;
            break;
        }
        if (headPos != null) {
            BlockPos.m_121990_(headPos, (BlockPos)pos).filter(p -> !p.equals((Object)pos)).forEach(p -> level.m_46961_(p, dropBlocks));
        }
        for (i = 1; i <= max && AllBlocks.PISTON_EXTENSION_POLE.has(cState = level.m_8055_(cPos = pos.m_5484_(dir, -i))) && dir.m_122434_() == ((Direction)cState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_(); ++i) {
            level.m_46961_(cPos, dropBlocks);
        }
        super.m_5707_(level, pos, state, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((BuilderState)((Object)state.m_61143_(STATE))).isFullBlock() ? Shapes.m_83144_() : AllShapes.MECHANICAL_PISTON_EXTENDED.get((Direction)state.m_61143_((Property)FACING));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        if (!level.f_46443_ && !level.m_183326_().m_183588_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 0);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        boolean prevPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (prevPowered != level.m_276867_(pos)) {
            if (((Boolean)(state = (BlockState)state.m_61122_((Property)POWERED)).m_61143_((Property)POWERED)).booleanValue()) {
                level.m_5594_(null, pos, AllSoundEvents.CONTRAPTION_ASSEMBLE.getMainEvent(), SoundSource.BLOCKS, 1.0f, 0.0f);
                CannonBuilderBlockEntity builder = (CannonBuilderBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
                if (builder != null) {
                    state = builder.updateBlockstatesOnPowered(state);
                }
            }
            level.m_7731_(pos, state, 2);
        }
    }

    public Class<CannonBuilderBlockEntity> getBlockEntityClass() {
        return CannonBuilderBlockEntity.class;
    }

    public BlockEntityType<? extends CannonBuilderBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CBCBlockEntities.CANNON_BUILDER.get();
    }

    public static int maxAllowedBuilderLength() {
        return (Integer)CBCConfigs.SERVER.crafting.maxCannonBuilderLength.get();
    }

    public static enum BuilderState implements StringRepresentable
    {
        UNACTIVATED("unactivated", true),
        ACTIVATED("activated", true),
        MOVING("moving", false),
        EXTENDED("extended", false);

        private final String name;
        private final boolean fullBlock;

        private BuilderState(String name, boolean fullBlock) {
            this.name = name;
            this.fullBlock = fullBlock;
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean isFullBlock() {
            return this.fullBlock;
        }
    }
}

