/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferedData;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.render.BlockEntityRenderHelper;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.client.model.data.ModelData;

public class SchematicRenderer {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final Map<RenderType, SuperByteBuffer> bufferCache = new LinkedHashMap<RenderType, SuperByteBuffer>(SchematicRenderer.getLayerCount());
    private boolean active;
    private boolean changed = false;
    protected SchematicWorld schematic;
    private BlockPos anchor;

    public void display(SchematicWorld world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.active = true;
        this.changed = true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void update() {
        this.changed = true;
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || !this.changed) {
            return;
        }
        this.redraw();
        this.changed = false;
    }

    public void render(PoseStack ms, SuperRenderTypeBuffer buffers) {
        if (!this.active) {
            return;
        }
        this.bufferCache.forEach((layer, buffer) -> buffer.renderInto(ms, buffers.m_6299_((RenderType)layer)));
        BlockEntityRenderHelper.renderBlockEntities(this.schematic, this.schematic.getRenderedBlockEntities(), ms, buffers);
    }

    protected void redraw() {
        this.bufferCache.forEach((layer, sbb) -> sbb.delete());
        this.bufferCache.clear();
        for (RenderType layer2 : RenderType.m_110506_()) {
            SuperByteBuffer buffer = this.drawLayer(layer2);
            if (!buffer.isEmpty()) {
                this.bufferCache.put(layer2, buffer);
                continue;
            }
            buffer.delete();
        }
    }

    protected SuperByteBuffer drawLayer(RenderType layer) {
        BlockRenderDispatcher dispatcher = ModelUtil.VANILLA_RENDERER;
        ModelBlockRenderer renderer = dispatcher.m_110937_();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        PoseStack poseStack = objects.poseStack;
        RandomSource random = objects.random;
        BlockPos.MutableBlockPos mutableBlockPos = objects.mutableBlockPos;
        SchematicWorld renderWorld = this.schematic;
        renderWorld.renderMode = true;
        BoundingBox bounds = renderWorld.getBounds();
        ShadeSeparatingVertexConsumer shadeSeparatingWrapper = objects.shadeSeparatingWrapper;
        BufferBuilder shadedBuilder = objects.shadedBuilder;
        BufferBuilder unshadedBuilder = objects.unshadedBuilder;
        shadedBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        unshadedBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        shadeSeparatingWrapper.prepare((VertexConsumer)shadedBuilder, (VertexConsumer)unshadedBuilder);
        ModelBlockRenderer.m_111000_();
        for (BlockPos localPos : BlockPos.m_121976_((int)bounds.m_162395_(), (int)bounds.m_162396_(), (int)bounds.m_162398_(), (int)bounds.m_162399_(), (int)bounds.m_162400_(), (int)bounds.m_162401_())) {
            BlockPos.MutableBlockPos pos = mutableBlockPos.m_175306_((Vec3i)localPos, (Vec3i)this.anchor);
            BlockState state = renderWorld.m_8055_((BlockPos)pos);
            if (state.m_60799_() != RenderShape.MODEL) continue;
            BakedModel model = dispatcher.m_110910_(state);
            BlockEntity blockEntity = renderWorld.m_7702_(localPos);
            ModelData modelData = blockEntity != null ? blockEntity.getModelData() : ModelData.EMPTY;
            modelData = model.getModelData((BlockAndTintGetter)renderWorld, (BlockPos)pos, state, modelData);
            long seed = state.m_60726_((BlockPos)pos);
            random.m_188584_(seed);
            if (!model.getRenderTypes(state, random, modelData).contains(layer)) continue;
            poseStack.m_85836_();
            poseStack.m_252880_((float)localPos.m_123341_(), (float)localPos.m_123342_(), (float)localPos.m_123343_());
            renderer.tesselateBlock((BlockAndTintGetter)renderWorld, model, state, (BlockPos)pos, poseStack, (VertexConsumer)shadeSeparatingWrapper, true, random, seed, OverlayTexture.f_118083_, modelData, layer);
            poseStack.m_85849_();
        }
        ModelBlockRenderer.m_111077_();
        shadeSeparatingWrapper.clear();
        ShadeSeparatedBufferedData bufferedData = ModelUtil.endAndCombine((BufferBuilder)shadedBuilder, (BufferBuilder)unshadedBuilder);
        renderWorld.renderMode = false;
        SuperByteBuffer sbb = new SuperByteBuffer(bufferedData);
        bufferedData.release();
        return sbb;
    }

    private static int getLayerCount() {
        return RenderType.m_110506_().size();
    }

    private static class ThreadLocalObjects {
        public final PoseStack poseStack = new PoseStack();
        public final RandomSource random = RandomSource.m_216343_();
        public final BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        public final ShadeSeparatingVertexConsumer shadeSeparatingWrapper = new ShadeSeparatingVertexConsumer();
        public final BufferBuilder shadedBuilder = new BufferBuilder(512);
        public final BufferBuilder unshadedBuilder = new BufferBuilder(512);

        private ThreadLocalObjects() {
        }
    }
}

