/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.endermanoverhaul.common.tags.ModBlockTags;

public class CaveEnderman
extends BaseEnderman {
    public CaveEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.2187).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public static boolean checkSpawnRules(EntityType<CaveEnderman> enderman, ServerLevelAccessor serverLevel, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        if (!EndermanOverhaulConfig.spawnCaveEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return pos.m_123342_() < serverLevel.m_5736_() && !serverLevel.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) && Monster.m_219013_(enderman, (ServerLevelAccessor)serverLevel, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new BaseEnderman.EndermanFreezeWhenLookedAt(this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new BaseEnderman.EndermanLeaveBlockGoal(this));
        this.f_21345_.m_25352_(11, (Goal)new BaseEnderman.EndermanTakeBlockGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new BaseEnderman.EndermanLookForPlayerGoal(this, arg_0 -> ((CaveEnderman)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public boolean isProvokedByEyeContact() {
        return false;
    }

    @Override
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.DUST.get();
    }

    @Override
    public boolean isAlwaysHostile() {
        return true;
    }

    @Override
    public double getVisionRange() {
        return 24.0;
    }

    @Override
    public TagKey<Block> getCarriableBlockTag() {
        return ModBlockTags.CAVE_ENDERMAN_HOLDEABLE;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.m_9236_().m_46467_() % 10L == 0L && this.m_6084_()) {
            if (this.m_9236_().m_45527_(this.m_20183_()) && this.m_9236_().m_46461_()) {
                this.m_6469_(this.m_269291_().m_269549_(), 1.0f);
                this.teleportUnderBlock();
            } else if (this.m_9236_().m_45517_(LightLayer.BLOCK, this.m_20183_()) > 6) {
                for (int i = 0; i < 64; ++i) {
                    if (!this.m_32529_()) continue;
                    this.m_6710_(null);
                    return;
                }
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_HURT.get();
    }

    private void teleportUnderBlock() {
        int range = 5;
        BlockPos.m_121886_((int)Mth.m_14107_((double)(this.m_20185_() - (double)range)), (int)Mth.m_14107_((double)(this.m_20186_() - 5.0)), (int)Mth.m_14107_((double)(this.m_20189_() - (double)range)), (int)Mth.m_14107_((double)(this.m_20185_() + (double)range)), (int)Mth.m_14107_((double)this.m_20186_()), (int)Mth.m_14107_((double)(this.m_20189_() + (double)range))).filter(pos -> this.m_9236_().m_8055_(pos).m_60795_() && this.m_9236_().m_8055_(pos.m_7494_()).m_60795_() && !this.m_9236_().m_45527_(pos)).findAny().ifPresent(pos -> {
            this.m_9236_().m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
            this.m_6021_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        });
        this.f_21344_.m_26573_();
    }
}

