/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.impl;

import com.mrcrayfish.backpacked.client.model.ModelInstances;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.data.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.tracker.ProgressFormatters;
import com.mrcrayfish.backpacked.data.tracker.UnlockManager;
import com.mrcrayfish.backpacked.data.tracker.impl.CountProgressTracker;
import com.mrcrayfish.framework.api.event.EntityEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.event.IEntityEvent;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;

public class EndCrystalBackpack
extends Backpack {
    public static final ResourceLocation ID = new ResourceLocation("backpacked", "end_crystal");

    public EndCrystalBackpack() {
        super(ID);
        EntityEvents.LIVING_ENTITY_DEATH.register((IFrameworkEvent)((IEntityEvent.LivingEntityDeath)this::onLivingEntityDeath));
    }

    @Override
    public Supplier<Object> getModelSupplier() {
        return ModelInstances.get()::getEndCrystal;
    }

    @Override
    @Nullable
    public IProgressTracker createProgressTracker() {
        return new CountProgressTracker(1, ProgressFormatters.INCOMPLETE_COMPLETE);
    }

    private boolean onLivingEntityDeath(LivingEntity entity, DamageSource source) {
        Entity sourceEntity = source.m_7639_();
        if (entity instanceof EnderDragon && sourceEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceEntity;
            UnlockManager.get((Player)player).flatMap(tracker -> tracker.getProgressTracker(ID)).ifPresent(tracker -> ((CountProgressTracker)tracker).increment(player));
        }
        return false;
    }
}

