/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.recipes;

import com.google.gson.JsonObject;
import com.ordana.spelunkery.reg.ModRecipes;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GrindstonePolishingRecipeBuilder {
    private final Item ingredient;
    private final Item result;
    private final int resultCount;
    private final Item byproduct;
    private final int byproductMin;
    private final int byproductMax;
    private final int experience;
    private final boolean requiresDiamondGrindstone;
    private final RecipeSerializer<?> serializer;
    private String recipeGroup;

    private GrindstonePolishingRecipeBuilder(ItemLike ingredient, ItemLike result, int resultCount, ItemLike byproduct, int byproductMin, int byproductMax, int experience, boolean requiresDiamondGrindstone, RecipeSerializer<?> serializer) {
        this.ingredient = ingredient.m_5456_();
        this.result = result.m_5456_();
        this.resultCount = resultCount;
        this.byproduct = byproduct.m_5456_();
        this.byproductMin = byproductMin;
        this.byproductMax = byproductMax;
        this.experience = experience;
        this.requiresDiamondGrindstone = requiresDiamondGrindstone;
        this.serializer = serializer;
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishing(ItemLike ingredient, ItemLike result) {
        return GrindstonePolishingRecipeBuilder.grindstonePolishing(ingredient, result, 1, (ItemLike)Blocks.f_50016_, 1, 1, 0, false);
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishingWithoutExperience(ItemLike ingredient, ItemLike result, int resultCount) {
        return GrindstonePolishingRecipeBuilder.grindstonePolishing(ingredient, result, resultCount, (ItemLike)Blocks.f_50016_, 0, 0, 0, false);
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishingWithoutCountWithByproduct(ItemLike ingredient, ItemLike result, ItemLike byproduct, int experience) {
        return GrindstonePolishingRecipeBuilder.grindstonePolishing(ingredient, result, 1, byproduct, 0, 1, experience, false);
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishingWithoutCountOrByproduct(ItemLike ingredient, ItemLike result, int experience) {
        return GrindstonePolishingRecipeBuilder.grindstonePolishing(ingredient, result, 1, (ItemLike)Blocks.f_50016_, 0, 0, experience, false);
    }

    public static GrindstonePolishingRecipeBuilder grindstonePolishing(ItemLike ingredient, ItemLike result, int resultCount, ItemLike byproduct, int byproductMin, int byproductMax, int experience, boolean requiresDiamondGrindstone) {
        return new GrindstonePolishingRecipeBuilder(ingredient, result, resultCount, byproduct, byproductMin, byproductMax, experience, requiresDiamondGrindstone, ModRecipes.GRINDSTONE_POLISHING_SERIALIZER.get());
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        ResourceLocation resourcelocation = BuiltInRegistries.f_257033_.m_7981_((Object)this.result);
        if (resourcelocation != null) {
            this.save(consumer, "spelunkery:grindstone_polishing/" + resourcelocation.m_135815_() + "_from_grindstone_polishing");
        }
    }

    public void save(Consumer<FinishedRecipe> pFinishedRecipeConsumer, String save) {
        ResourceLocation resourcelocation = new ResourceLocation(save);
        ResourceLocation defaultResourcelocation = BuiltInRegistries.f_257033_.m_7981_((Object)this.result);
        if (resourcelocation.equals((Object)defaultResourcelocation)) {
            throw new IllegalStateException("Polishing Recipe " + save + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(pFinishedRecipeConsumer, resourcelocation);
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.serializer, this.recipeGroup == null ? "" : this.recipeGroup, this.ingredient, this.result, this.resultCount, this.byproduct, this.byproductMin, this.byproductMax, this.experience, this.requiresDiamondGrindstone));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final RecipeSerializer<?> serializer;
        private final String group;
        private final Item ingredient;
        private final Item result;
        private final int resultCount;
        private final Item byproduct;
        private final int byproductMin;
        private final int byproductMax;
        private final int experience;
        private final boolean requiresDiamondGrindstone;

        public Result(ResourceLocation pId, RecipeSerializer<?> serializer, String pGroup, Item pIngredient, Item pResult, int resultCount, Item pByproduct, int byproductMin, int byproductMax, int experience, boolean requiresDiamondGrindstone) {
            this.id = pId;
            this.serializer = serializer;
            this.group = pGroup;
            this.ingredient = pIngredient;
            this.result = pResult;
            this.resultCount = resultCount;
            this.byproduct = pByproduct;
            this.byproductMin = byproductMin;
            this.byproductMax = byproductMax;
            this.experience = experience;
            this.requiresDiamondGrindstone = requiresDiamondGrindstone;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.addProperty("ingredient", BuiltInRegistries.f_257033_.m_7981_((Object)this.ingredient).toString());
            pJson.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            pJson.addProperty("resultCount", (Number)this.resultCount);
            pJson.addProperty("byproduct", BuiltInRegistries.f_257033_.m_7981_((Object)this.byproduct).toString());
            pJson.addProperty("byproductMin", (Number)this.byproductMin);
            pJson.addProperty("byproductMax", (Number)this.byproductMax);
            pJson.addProperty("experience", (Number)this.experience);
            pJson.addProperty("requiresDiamondGrindstone", Boolean.valueOf(this.requiresDiamondGrindstone));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

