/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.ordana.spelunkery.features.HugeConkFungusFeatureConfig;
import com.ordana.spelunkery.reg.ModBlocks;
import java.util.HashSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class HugeConkFungusFeature
extends Feature<HugeConkFungusFeatureConfig> {
    public HugeConkFungusFeature(Codec<HugeConkFungusFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HugeConkFungusFeatureConfig> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = level.m_213780_();
        BlockPos blockPos = context.m_159777_();
        HugeConkFungusFeatureConfig config = (HugeConkFungusFeatureConfig)context.m_159778_();
        HashSet set = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> blockSetter = (blockPosx, blockState) -> {
            set.add(blockPosx.m_7949_());
            level.m_7731_(blockPosx, blockState, 19);
        };
        BiConsumer<BlockPos, BlockState> blockSetter2 = (blockPosx, blockState) -> {
            set.add(blockPosx.m_7949_());
            level.m_7731_(blockPosx, (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)PipeBlock.f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55151_, (Comparable)Boolean.valueOf(false)), 19);
        };
        int radius = random.m_188503_(2) + config.radius;
        int i = 0;
        if (config.largeChance > 0) {
            i = random.m_216339_(0, config.largeChance);
        }
        boolean large = i == 1;
        this.placeLeavesRow((LevelSimulatedReader)level, blockSetter2, random, config, blockPos, radius - 1, 0, large);
        this.placeLeavesRow((LevelSimulatedReader)level, blockSetter, random, config, blockPos, radius, -1, large);
        return false;
    }

    protected void placeLeavesRow(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, HugeConkFungusFeatureConfig config, BlockPos pos, int range, int yOffset, boolean large) {
        int i = large ? 1 : 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int j = -range; j <= range + i; ++j) {
            for (int k = -range; k <= range + i; ++k) {
                if (this.shouldSkipLocationSignedOg(random, j, yOffset, k, range, large)) continue;
                mutableBlockPos.m_122154_((Vec3i)pos, j, yOffset, k);
                HugeConkFungusFeature.tryPlaceLeaf(level, blockSetter, random, config, (BlockPos)mutableBlockPos);
            }
        }
    }

    protected static void tryPlaceLeaf(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, HugeConkFungusFeatureConfig config, BlockPos pos) {
        if (HugeConkFungusFeature.validTreePos(level, pos)) {
            BlockState blockState = config.foliageProvider.m_213972_(random, pos);
            if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(pos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
            }
            blockSetter.accept(pos, blockState);
        }
    }

    public static boolean isBlockWater(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, blockState -> blockState.m_60713_(Blocks.f_49990_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, blockState -> blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13035_) || blockState.m_60713_(ModBlocks.CONK_FUNGUS.get()));
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_247087_);
    }

    public static boolean validTreePos(LevelSimulatedReader level, BlockPos pos) {
        return HugeConkFungusFeature.isAirOrLeaves(level, pos) || HugeConkFungusFeature.isReplaceablePlant(level, pos) || HugeConkFungusFeature.isBlockWater(level, pos);
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && range > 0;
    }

    protected boolean shouldSkipLocationSignedOg(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        int j;
        int i;
        if (large) {
            i = Math.min(Math.abs(localX), Math.abs(localX - 1));
            j = Math.min(Math.abs(localZ), Math.abs(localZ - 1));
        } else {
            i = Math.abs(localX);
            j = Math.abs(localZ);
        }
        return this.shouldSkipLocation(random, i, localY, j, range, large);
    }
}

