/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.events;

import com.ordana.spelunkery.blocks.PortalFluidCauldronBlock;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.items.PortalFluidBottleitem;
import com.ordana.spelunkery.recipes.GrindstonePolishingRecipe;
import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModSoundEvents;
import com.ordana.spelunkery.reg.ModTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CryingObsidianBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ModEvents {
    private static final List<InteractionEvent> EVENTS = new ArrayList<InteractionEvent>();

    public static InteractionResult onBlockCLicked(ItemStack stack, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        Item i = stack.m_41720_();
        BlockPos pos = hitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        for (InteractionEvent event : EVENTS) {
            InteractionResult result = event.run(i, stack, pos, state, player, level, hand, hitResult);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult portalCauldronLogic(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item == Items.f_42590_) {
            if (state.m_60734_() instanceof PortalFluidCauldronBlock) {
                level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.PORTAL_FLUID_BOTTLE.get().m_7968_());
                    player.m_21008_(hand, itemStack2);
                    if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) > 1) {
                        level.m_46597_(pos, (BlockState)ModBlocks.PORTAL_CAULDRON.get().m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) - 1)));
                    } else {
                        level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                    }
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else if (item == Items.f_42446_ && state.m_60734_() instanceof PortalFluidCauldronBlock && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3) {
            level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BUCKET_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.PORTAL_FLUID_BUCKET.get().m_7968_());
                player.m_21008_(hand, itemStack2);
                level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult saltBoiling(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item == ModItems.SALT.get() && state.m_60713_(Blocks.f_152476_) && level.m_8055_(pos.m_7495_()).m_204336_(ModTags.CAN_BOIL_WATER)) {
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5594_(player, pos, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.ROCK_SALT.get().m_7968_());
                player.m_21008_(hand, itemStack2);
                if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) > 1) {
                    level.m_46597_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) - 1)));
                } else {
                    level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                }
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult obsidianDraining(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item == Items.f_42590_) {
            if (state.m_60734_() instanceof CryingObsidianBlock && CommonConfigs.CRYING_OBSIDIAN_PORTAL_FLUID.get().booleanValue()) {
                level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123787_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.PORTAL_FLUID_BOTTLE.get().m_7968_());
                    player.m_21008_(hand, itemStack2);
                    level.m_46597_(pos, Blocks.f_50080_.m_49966_());
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (state.m_60734_() instanceof RespawnAnchorBlock && (Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0 && CommonConfigs.RESPAWN_ANCHOR_PORTAL_FLUID.get().booleanValue()) {
                level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123787_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStack itemStack2 = new ItemStack((ItemLike)ModItems.PORTAL_FLUID_BOTTLE.get());
                    PortalFluidBottleitem.addLocationTags((ResourceKey<Level>)level.m_46472_(), pos, itemStack2.m_41784_());
                    if (!player.m_150109_().m_36054_(itemStack2)) {
                        player.m_36176_(itemStack2, false);
                    }
                    stack.m_41774_(1);
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)RespawnAnchorBlock.f_55833_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) - 1)));
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult polishingRecipe(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (state.m_60734_() instanceof GrindstoneBlock) {
            ArrayList<GrindstonePolishingRecipe> recipes = new ArrayList<GrindstonePolishingRecipe>(GrindstonePolishingRecipe.getRecipes(level));
            for (GrindstonePolishingRecipe polishingRecipe : recipes) {
                if (recipes.isEmpty()) continue;
                RandomSource random = level.m_213780_();
                ItemStack ingredient = polishingRecipe.ingredient;
                ItemStack result = polishingRecipe.m_8043_(level.m_9598_());
                int resultCount = polishingRecipe.getResultCount();
                ItemStack byproduct = polishingRecipe.getByproduct();
                int byproductCount = random.m_216332_(polishingRecipe.getByproductMin(), polishingRecipe.getByproductMax());
                int xpAmount = polishingRecipe.getExperience();
                if (!stack.m_150930_(ingredient.m_41720_())) continue;
                ItemStack resultItem = result.m_41777_();
                ItemStack byproductItem = byproduct.m_41777_();
                if (player.m_6144_() && stack.m_204117_(ModTags.GRINDSTONE_REPAIR_ITEM) && state.m_60713_(ModBlocks.DIAMOND_GRINDSTONE.get()) && (Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) > 0) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                    }
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.DEPLETION, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) - 1)));
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                } else {
                    if (state.m_60713_(ModBlocks.DIAMOND_GRINDSTONE.get()) && (Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) == 3 && polishingRecipe.isRequiresDiamondGrindstone() || polishingRecipe.isRequiresDiamondGrindstone() && !state.m_60713_(ModBlocks.DIAMOND_GRINDSTONE.get())) {
                        ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123762_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                        player.m_6674_(hand);
                        level.m_5594_(player, pos, SoundEvents.f_12347_, SoundSource.BLOCKS, 0.5f, 0.0f);
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    if (player.m_6144_()) {
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                        }
                        int ingredientCount = stack.m_41613_();
                        for (int b = 0; b <= ingredientCount; ++b) {
                            byproductCount += random.m_216332_(polishingRecipe.getByproductMin(), polishingRecipe.getByproductMax());
                        }
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(ingredientCount);
                        }
                        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount * ingredientCount))) {
                            player.m_36176_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount * ingredientCount), false);
                        }
                        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)byproductItem.m_41720_(), byproductCount))) {
                            player.m_36176_(new ItemStack((ItemLike)byproductItem.m_41720_(), byproductCount), false);
                        }
                        if (xpAmount != 0) {
                            for (int i = 0; i <= ingredientCount; ++i) {
                                xpAmount += polishingRecipe.getExperience();
                            }
                            level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), xpAmount));
                        }
                    } else {
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                        }
                        resultItem.m_41764_(resultCount);
                        byproductItem.m_41764_(byproductCount);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount))) {
                            player.m_36176_(new ItemStack((ItemLike)resultItem.m_41720_(), resultCount), false);
                        }
                        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)byproduct.m_41720_(), byproductCount))) {
                            player.m_36176_(new ItemStack((ItemLike)byproductItem.m_41720_(), byproductCount), false);
                        }
                        if (xpAmount != 0) {
                            level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), xpAmount));
                        }
                    }
                }
                if (!resultItem.m_150930_(Items.f_41852_)) {
                    ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, resultItem), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                } else {
                    ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, byproductItem), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                }
                player.m_6674_(hand);
                level.m_5594_(player, pos, SoundEvents.f_11998_, SoundSource.BLOCKS, 0.5f, 0.0f);
                if (random.m_188503_(CommonConfigs.DIAMOND_GRINDSTONE_DEPLETE_CHANCE.get().intValue()) == 1 && !CommonConfigs.DISABLE_DIAMOND_GRINDSTONE_DEPLETION.get().booleanValue() && polishingRecipe.isRequiresDiamondGrindstone() && state.m_60713_(ModBlocks.DIAMOND_GRINDSTONE.get()) && (Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) < 3) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.DEPLETION, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) + 1)));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult anvilRepairing(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.m_204117_(ModTags.ANVIL_REPAIR_ITEM) && state.m_204336_(BlockTags.f_13033_) && !state.m_60713_(Blocks.f_50322_)) {
            level.m_5594_(player, pos, SoundEvents.f_11667_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5594_(player, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (state.m_60713_(Blocks.f_50323_)) {
                    level.m_46597_(pos, Blocks.f_50322_.m_49966_().m_60734_().m_152465_(state));
                } else if (state.m_60713_(Blocks.f_50324_)) {
                    level.m_46597_(pos, Blocks.f_50323_.m_49966_().m_60734_().m_152465_(state));
                }
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    static {
        EVENTS.add(ModEvents::obsidianDraining);
        EVENTS.add(ModEvents::portalCauldronLogic);
        EVENTS.add(ModEvents::saltBoiling);
        EVENTS.add(ModEvents::polishingRecipe);
        EVENTS.add(ModEvents::anvilRepairing);
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public InteractionResult run(Item var1, ItemStack var2, BlockPos var3, BlockState var4, Player var5, Level var6, InteractionHand var7, BlockHitResult var8);
    }
}

