/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.nephrite;

import com.ordana.spelunkery.blocks.entity.CarvedNephriteBlockEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NephriteSiphonBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public NephriteSiphonBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ArrayList<CarvedNephriteBlockEntity> neighbors = new ArrayList<CarvedNephriteBlockEntity>();
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            if (direction.equals((Object)Direction.UP) || !((blockEntity = level.m_7702_(pos.m_121945_(direction))) instanceof CarvedNephriteBlockEntity)) continue;
            CarvedNephriteBlockEntity neighborTile = (CarvedNephriteBlockEntity)blockEntity;
            neighbors.add(neighborTile);
        }
        if (neighbors.isEmpty()) {
            return;
        }
        CarvedNephriteBlockEntity chosenNeighbor = (CarvedNephriteBlockEntity)((Object)neighbors.get(level.f_46441_.m_188503_(neighbors.size())));
        if (entity instanceof ExperienceOrb) {
            ExperienceOrb xpOrb = (ExperienceOrb)entity;
            if (chosenNeighbor.getCharge() + xpOrb.m_20801_() < 100) {
                chosenNeighbor.setCharge(chosenNeighbor.getCharge() + xpOrb.m_20801_());
                xpOrb.m_146870_();
                float f = level.f_46441_.m_188501_();
                level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, f * 0.9f, (f + 1.0f) / 2.0f);
            }
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        ArrayList<CarvedNephriteBlockEntity> neighbors = new ArrayList<CarvedNephriteBlockEntity>();
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            if (direction.equals((Object)Direction.UP) || !((blockEntity = level.m_7702_(pos.m_121945_(direction))) instanceof CarvedNephriteBlockEntity)) continue;
            CarvedNephriteBlockEntity neighborTile = (CarvedNephriteBlockEntity)blockEntity;
            neighbors.add(neighborTile);
        }
        if (neighbors.isEmpty()) {
            return;
        }
        CarvedNephriteBlockEntity chosenNeighbor = (CarvedNephriteBlockEntity)((Object)neighbors.get(level.f_46441_.m_188503_(neighbors.size())));
        if (entity instanceof ExperienceOrb) {
            ExperienceOrb xpOrb = (ExperienceOrb)entity;
            if (chosenNeighbor.getCharge() + xpOrb.m_20801_() < 100) {
                chosenNeighbor.setCharge(chosenNeighbor.getCharge() + xpOrb.m_20801_());
                xpOrb.m_146870_();
                float f = level.f_46441_.m_188501_();
                level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, f * 0.9f, (f + 1.0f) / 2.0f);
            }
        }
        if (entity instanceof Player && ((player = (Player)entity).m_6047_() || player.f_19797_ % 10 == 0) && (player.f_36079_ > 0 || player.f_36078_ > 0 && player.f_36079_ == 0) && chosenNeighbor.getCharge() < 100) {
            chosenNeighbor.setCharge(chosenNeighbor.getCharge() + 1);
            player.m_6756_(-1);
            float f = level.f_46441_.m_188501_();
            level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, f * 0.9f, (f + 1.0f) / 2.0f - 0.3f);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext c;
        Entity e;
        if (context instanceof EntityCollisionContext && (e = (c = (EntityCollisionContext)context).m_193113_()) instanceof ExperienceOrb) {
            return Shapes.m_83040_();
        }
        return SHAPE;
    }
}

