/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.entity;

import com.ordana.spelunkery.blocks.nephrite.CarvedNephriteBlock;
import com.ordana.spelunkery.reg.ModEntities;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CarvedNephriteBlockEntity
extends BlockEntity {
    private int charge = 0;
    private int tickCounter = 0;
    private int maxCharge = 100;

    public CarvedNephriteBlockEntity(BlockPos pos, BlockState state) {
        super(ModEntities.NEPHRITE_TILE.get(), pos, state);
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public int getCharge() {
        return this.charge;
    }

    public int setCharge(int newCharge) {
        this.charge = newCharge;
        return this.charge;
    }

    public static void runFlow(Level level, BlockPos pos, BlockState state, CarvedNephriteBlockEntity selfTile) {
        CarvedNephriteBlockEntity block2;
        BlockEntity blockEntity;
        int selfCharge = selfTile.getCharge();
        boolean numOfNeighbors = true;
        int i = 0;
        BlockPos bottomBlock = null;
        while (bottomBlock == null) {
            CarvedNephriteBlockEntity nephrite;
            if (!(level.m_7702_(pos.m_6625_(i + 1)) instanceof CarvedNephriteBlockEntity) || (blockEntity = level.m_7702_(pos.m_6625_(i + 1))) instanceof CarvedNephriteBlockEntity && (nephrite = (CarvedNephriteBlockEntity)blockEntity).getCharge() >= 100) {
                bottomBlock = pos.m_6625_(i);
            }
            ++i;
        }
        if (!bottomBlock.equals((Object)pos) && (blockEntity = level.m_7702_(bottomBlock)) instanceof CarvedNephriteBlockEntity) {
            CarvedNephriteBlockEntity belowTile = (CarvedNephriteBlockEntity)blockEntity;
            int belowCharge = belowTile.getCharge();
            if (selfCharge + belowCharge <= 100) {
                belowTile.setCharge(belowCharge + selfCharge);
                selfTile.setCharge(0);
            } else {
                selfTile.setCharge(selfCharge - (100 - belowCharge));
                belowTile.setCharge(100);
            }
        }
        int sumOfCharge = selfCharge = selfTile.getCharge();
        ArrayList<CarvedNephriteBlockEntity> neighbors = new ArrayList<CarvedNephriteBlockEntity>();
        for (Object direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_((Direction)direction);
            BlockEntity blockEntity2 = level.m_7702_(neighborPos);
            if (!(blockEntity2 instanceof CarvedNephriteBlockEntity)) continue;
            CarvedNephriteBlockEntity neighborTile = (CarvedNephriteBlockEntity)blockEntity2;
            neighbors.add(neighborTile);
            sumOfCharge += neighborTile.getCharge();
        }
        boolean remainderGiven = false;
        Collections.shuffle(neighbors);
        for (CarvedNephriteBlockEntity block2 : neighbors) {
            if (!remainderGiven && level.f_46441_.m_188503_(neighbors.size() + 1) == 0) {
                block2.setCharge(sumOfCharge / (neighbors.size() + 1) + sumOfCharge % (neighbors.size() + 1));
                remainderGiven = true;
                continue;
            }
            block2.setCharge(sumOfCharge / (neighbors.size() + 1));
        }
        if (remainderGiven) {
            selfTile.setCharge(sumOfCharge / (neighbors.size() + 1));
        } else {
            selfTile.setCharge(sumOfCharge / (neighbors.size() + 1) + sumOfCharge % (neighbors.size() + 1));
        }
        selfCharge = selfTile.getCharge();
        if (!bottomBlock.equals((Object)pos) && (block2 = level.m_7702_(bottomBlock)) instanceof CarvedNephriteBlockEntity) {
            CarvedNephriteBlockEntity bottomTile = block2;
            int belowCharge = bottomTile.getCharge();
            if (selfCharge + belowCharge <= 100) {
                bottomTile.setCharge(belowCharge + selfCharge);
                selfTile.setCharge(0);
            } else {
                selfTile.setCharge(selfCharge - (100 - belowCharge));
                bottomTile.setCharge(100);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Charge")) {
            this.setCharge(tag.m_128451_("Charge"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128405_("Charge", this.getCharge());
        super.m_183515_(tag);
    }

    public static void tickBlock(Level level, BlockPos pos, BlockState state, CarvedNephriteBlockEntity selfTile) {
        ++selfTile.tickCounter;
        if (!level.f_46443_ && selfTile.tickCounter == 5) {
            CarvedNephriteBlockEntity.runFlow(level, pos, state, selfTile);
            selfTile.setTickCounter(0);
        }
        if (selfTile.getCharge() == 0) {
            level.m_46597_(pos, (BlockState)state.m_61124_(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.EMPTY)));
        } else if (selfTile.getCharge() > 0 && selfTile.getCharge() <= 20) {
            level.m_46597_(pos, (BlockState)state.m_61124_(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.ONE_TO_TWENTY)));
        } else if (selfTile.getCharge() > 20 && selfTile.getCharge() <= 40) {
            level.m_46597_(pos, (BlockState)state.m_61124_(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.TWENTYONE_TO_FOURTY)));
        } else if (selfTile.getCharge() > 40 && selfTile.getCharge() <= 60) {
            level.m_46597_(pos, (BlockState)state.m_61124_(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.FOURTYONE_TO_SIXTY)));
        } else if (selfTile.getCharge() > 60 && selfTile.getCharge() <= 80) {
            level.m_46597_(pos, (BlockState)state.m_61124_(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.SIXTYONE_TO_EIGHTY)));
        } else if (selfTile.getCharge() > 80 && selfTile.getCharge() <= 99) {
            level.m_46597_(pos, (BlockState)state.m_61124_(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.EIGHTYONE_TO_NINETYNINE)));
        } else if (selfTile.getCharge() == 100) {
            level.m_46597_(pos, (BlockState)state.m_61124_(CarvedNephriteBlock.CHARGE, (Comparable)((Object)CarvedNephriteBlock.ChargeState.FULL)));
        }
    }
}

