/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import dan200.computercraft.api.ForgeComputerCraftAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.media.items.PrintoutItem;
import java.util.Objects;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCCompatImpl {
    public static void setup() {
        ForgeComputerCraftAPI.registerPeripheralProvider((level, blockPos, direction) -> {
            BlockEntity tile = level.m_7702_(blockPos);
            if (tile instanceof SpeakerBlockTile) {
                return tile.getCapability(Capabilities.CAPABILITY_PERIPHERAL, direction);
            }
            return LazyOptional.empty();
        });
    }

    public static int getPages(ItemStack itemstack) {
        return PrintoutItem.getPageCount((ItemStack)itemstack);
    }

    public static String[] getText(ItemStack itemstack) {
        return PrintoutItem.getText((ItemStack)itemstack);
    }

    public static boolean isPrintedBook(Item item) {
        return item instanceof PrintoutItem;
    }

    public static boolean isPeripheralCap(Capability<?> cap) {
        return cap == Capabilities.CAPABILITY_PERIPHERAL;
    }

    public static LazyOptional<Object> getPeripheralSupplier(SpeakerBlockTile tile) {
        return LazyOptional.of(() -> new SpeakerPeripheral(tile));
    }

    public static final class SpeakerPeripheral
    implements IPeripheral {
        private final SpeakerBlockTile tile;

        public SpeakerPeripheral(SpeakerBlockTile tile) {
            this.tile = tile;
        }

        @LuaFunction
        public void setNarrator(SpeakerBlockTile.Mode mode) {
            this.tile.setMode(mode);
            this.tile.m_6596_();
        }

        @LuaFunction
        public SpeakerBlockTile.Mode getMode() {
            return this.tile.getMode();
        }

        @LuaFunction
        public void setMessage(String message) {
            this.tile.setMessage((Component)Component.m_237113_((String)message));
            this.tile.m_6596_();
        }

        @LuaFunction
        public String getMessage() {
            return this.tile.getMessage(false).getString();
        }

        @LuaFunction
        public void setName(String name) {
            this.tile.setCustomName((Component)Component.m_237113_((String)name));
            this.tile.m_6596_();
        }

        @LuaFunction
        public String getName() {
            return this.tile.m_7755_().getString();
        }

        @LuaFunction
        public double getVolume() {
            return this.tile.getVolume();
        }

        @LuaFunction
        public void setVolume(double volume) {
            this.tile.setVolume(volume);
            this.tile.m_6596_();
        }

        @LuaFunction
        public void activate() {
            this.tile.sendMessage();
        }

        @NotNull
        public String getType() {
            return "speaker_block";
        }

        public boolean equals(@Nullable IPeripheral other) {
            return Objects.equals(this, other);
        }

        public SpeakerBlockTile tile() {
            return this.tile;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SpeakerPeripheral that = (SpeakerPeripheral)obj;
            return Objects.equals(this.tile, that.tile);
        }

        public int hashCode() {
            return Objects.hash(this.tile);
        }

        public String toString() {
            return "SpeakerPeripheral[tile=" + this.tile + "]";
        }
    }
}

