/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.utils;

public enum CrowbarMode {
    CONNECT("connect"),
    DISCONNECT("disconnect"),
    REVERT("revert"),
    LABEL("label");

    private final String label;

    public CrowbarMode next() {
        switch (this) {
            case CONNECT: {
                return DISCONNECT;
            }
            case DISCONNECT: {
                return REVERT;
            }
            case REVERT: {
                return LABEL;
            }
            case LABEL: {
                return CONNECT;
            }
        }
        return null;
    }

    public static CrowbarMode getFromLabel(String label) {
        for (CrowbarMode mode : CrowbarMode.values()) {
            if (!mode.label.equals(label)) continue;
            return mode;
        }
        return CONNECT;
    }

    public String getLabel() {
        return this.label;
    }

    private CrowbarMode(String label) {
        this.label = label;
    }
}

