/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import hu.xannosz.betterminecarts.screen.ButtonConfig;
import hu.xannosz.betterminecarts.screen.ElectricLocomotiveMenu;
import hu.xannosz.betterminecarts.screen.GraphicalButton;
import hu.xannosz.betterminecarts.utils.ButtonId;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ScreenUtils;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ElectricLocomotiveScreen
extends AbstractContainerScreen<ElectricLocomotiveMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("betterminecarts", "textures/gui/electric_locomotive.png");
    private int x;
    private int y;
    private GraphicalButton back;
    private GraphicalButton stop;
    private GraphicalButton forward;
    private GraphicalButton fForward;
    private GraphicalButton ffForward;
    private GraphicalButton lamp;
    private GraphicalButton whistle;
    private GraphicalButton redstone;

    public ElectricLocomotiveScreen(ElectricLocomotiveMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97727_ = 42;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        this.back = new GraphicalButton(this.generateConfig(26, 0, 7, ButtonId.BACK));
        this.stop = new GraphicalButton(this.generateConfig(34, 7, 7, ButtonId.STOP));
        this.forward = new GraphicalButton(this.generateConfig(42, 14, 7, ButtonId.FORWARD));
        this.fForward = new GraphicalButton(this.generateConfig(50, 21, 10, ButtonId.F_FORWARD));
        this.ffForward = new GraphicalButton(this.generateConfig(61, 31, 13, ButtonId.FF_FORWARD));
        this.lamp = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.LAMP).hitBoxX(this.x + 155).hitBoxY(this.y + 7).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(1).build());
        this.whistle = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.WHISTLE).hitBoxX(this.x + 155).hitBoxY(this.y + 23).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(13).build());
        this.redstone = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.REDSTONE).hitBoxX(this.x + 139).hitBoxY(this.y + 23).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(25).build());
        this.m_142416_((GuiEventListener)this.back);
        this.m_142416_((GuiEventListener)this.stop);
        this.m_142416_((GuiEventListener)this.forward);
        this.m_142416_((GuiEventListener)this.fForward);
        this.m_142416_((GuiEventListener)this.ffForward);
        this.m_142416_((GuiEventListener)this.lamp);
        this.m_142416_((GuiEventListener)this.whistle);
        this.m_142416_((GuiEventListener)this.redstone);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableBlend();
        guiGraphics.m_280218_(TEXTURE, this.x, this.y, 0, 0, this.f_97726_, this.f_97727_);
        this.back.setEntityId(((ElectricLocomotiveMenu)this.f_97732_).getElectricLocomotiveId());
        this.stop.setEntityId(((ElectricLocomotiveMenu)this.f_97732_).getElectricLocomotiveId());
        this.forward.setEntityId(((ElectricLocomotiveMenu)this.f_97732_).getElectricLocomotiveId());
        this.fForward.setEntityId(((ElectricLocomotiveMenu)this.f_97732_).getElectricLocomotiveId());
        this.ffForward.setEntityId(((ElectricLocomotiveMenu)this.f_97732_).getElectricLocomotiveId());
        this.lamp.setEntityId(((ElectricLocomotiveMenu)this.f_97732_).getElectricLocomotiveId());
        this.whistle.setEntityId(((ElectricLocomotiveMenu)this.f_97732_).getElectricLocomotiveId());
        this.redstone.setEntityId(((ElectricLocomotiveMenu)this.f_97732_).getElectricLocomotiveId());
        this.back.setSelected(false);
        this.stop.setSelected(false);
        this.forward.setSelected(false);
        this.fForward.setSelected(false);
        this.ffForward.setSelected(false);
        switch (((ElectricLocomotiveMenu)this.f_97732_).getActiveButton()) {
            case BACK: {
                this.back.setSelected(true);
                break;
            }
            case STOP: {
                this.stop.setSelected(true);
                break;
            }
            case FORWARD: {
                this.forward.setSelected(true);
                break;
            }
            case F_FORWARD: {
                this.fForward.setSelected(true);
                break;
            }
            case FF_FORWARD: {
                this.ffForward.setSelected(true);
            }
        }
        this.lamp.setSelected(((ElectricLocomotiveMenu)this.f_97732_).isLampOn());
        this.redstone.setSelected(((ElectricLocomotiveMenu)this.f_97732_).isSignalActive());
        int power = ((ElectricLocomotiveMenu)this.f_97732_).getPower();
        if (power > 20) {
            power = 20;
        }
        int t = power * 140 / 20;
        ScreenUtils.drawTexturedModalRect((GuiGraphics)guiGraphics, (int)(this.x + 6), (int)(this.y + 6), (int)0, (int)43, (int)t, (int)12, (float)partialTick);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private ButtonConfig generateConfig(int buttonX, int hoverX, int w, ButtonId buttonId) {
        return ButtonConfig.builder().buttonId(buttonId).hitBoxX(this.x + buttonX).hitBoxY(this.y + 24).hitBoxW(w).hitBoxH(9).hoveredX(hoverX).hoveredY(55).build();
    }
}

