/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.entity;

import hu.xannosz.betterminecarts.entity.ModEntities;
import hu.xannosz.betterminecarts.item.ModItems;
import hu.xannosz.betterminecarts.screen.SteamLocomotiveMenu;
import hu.xannosz.betterminecarts.utils.MinecartHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MeltingMinecart
extends AbstractMinecart
implements MenuProvider,
Container {
    public static final int ID_KEY_1 = 0;
    public static final int ID_KEY_2 = 1;
    public static final int BURN_KEY = 2;
    public static final int MAX_BURN_KEY = 3;
    public static final int COOKING_KEY = 4;
    public static final int MAX_COOKING_KEY = 5;
    public static final int DATA_SIZE = 6;
    private int burn = 0;
    private int maxBurn = 0;
    private int cooking = 0;
    private int maxCooking = 0;
    private final ContainerData data = new SimpleContainerData(6);
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 1 -> true;
                case 2 -> {
                    if (ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public MeltingMinecart(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public MeltingMinecart(double x, double y, double z, Level level) {
        super((EntityType)ModEntities.CRAFTING_MINECART.get(), level, x, y, z);
    }

    @NotNull
    protected Item m_213728_() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (Container)inventory);
        return Items.f_42520_;
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        this.updateData();
        return new SteamLocomotiveMenu(id, inventory, (Entity)this, this.data);
    }

    @NotNull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.FURNACE;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.CROWBAR.get())) {
            return super.m_6096_(player, hand);
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        player.m_5893_((MenuProvider)this);
        return InteractionResult.SUCCESS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        --this.burn;
        this.burn = Math.max(this.burn, 0);
        this.updateData();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MinecartHelper.IS_BURN, (Object)false);
    }

    public void updateData() {
        short[] ids = MinecartHelper.intToShorts(this.m_19879_());
        this.data.m_8050_(0, (int)ids[0]);
        this.data.m_8050_(1, (int)ids[1]);
        this.data.m_8050_(4, this.cooking);
        this.data.m_8050_(5, this.maxCooking);
        this.data.m_8050_(2, this.burn);
        this.data.m_8050_(3, this.maxBurn);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(MinecartHelper.IS_BURN, (Object)(this.burn > 0 ? 1 : 0));
    }

    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Cooking", this.cooking);
        compoundTag.m_128405_("MaxCooking", this.maxCooking);
        compoundTag.m_128405_("Burn", this.burn);
        compoundTag.m_128405_("MaxBurn", this.maxBurn);
        compoundTag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.cooking = compoundTag.m_128451_("Cooking");
        this.maxCooking = compoundTag.m_128451_("MaxCooking");
        this.burn = compoundTag.m_128451_("Burn");
        this.maxBurn = compoundTag.m_128451_("MaxBurn");
        this.itemHandler.deserializeNBT(compoundTag.m_128469_("Inventory"));
        this.updateData();
    }

    @NotNull
    public BlockState m_38178_() {
        return Blocks.f_50094_.m_49966_();
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemstack = this.itemHandler.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int count) {
        if (slot == 0) {
            return count > 0 ? this.itemHandler.getStackInSlot(slot).m_41620_(count) : ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Blocks.f_50016_, 0);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return this.m_8020_(slot);
    }

    public void m_6836_(int slot, @NotNull ItemStack itemStack) {
        this.itemHandler.setStackInSlot(slot, itemStack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player player) {
        return false;
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, new ItemStack((ItemLike)Blocks.f_50016_, 0));
        }
    }

    public boolean m_7013_(int slot, @NotNull ItemStack itemStack) {
        return this.itemHandler.isItemValid(slot, itemStack);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IItemHandler> getLazyItemHandler() {
        return this.lazyItemHandler;
    }
}

