/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import party.lemons.biomemakeover.util.extension.Stuntable;

@Mixin(value={Tadpole.class})
public abstract class TadpoleMixin
extends AbstractFish
implements Stuntable {
    @Shadow
    private int f_218680_;
    private boolean isStunted = false;

    @Shadow
    public abstract void m_7378_(CompoundTag var1);

    public TadpoleMixin(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    private void addAdditionalData(CompoundTag tag, CallbackInfo cbi) {
        tag.m_128379_("bm_IsStunted", this.isStunted());
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    private void readAdditionalData(CompoundTag tag, CallbackInfo cbi) {
        if (tag.m_128441_("bm_IsStunted")) {
            this.setStunted(tag.m_128471_("bm_IsStunted"));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getAge"}, cancellable=true)
    public void getAge(CallbackInfoReturnable<Integer> cbi) {
        if (this.isStunted()) {
            cbi.setReturnValue((Object)-6000);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setAge"}, cancellable=true)
    public void setAge(int age, CallbackInfo cbi) {
        if (this.isStunted()) {
            this.f_218680_ = -6000;
            cbi.cancel();
        }
    }

    @Override
    public boolean isAlwaysBaby() {
        return true;
    }

    @Override
    public boolean isStunted() {
        return this.isStunted;
    }

    @Override
    public void setStunted(boolean stunted) {
        this.isStunted = stunted;
    }
}

