/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.VegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.lighting.LightEngine;

public class GrassPatchFeature
extends VegetationPatchFeature {
    public GrassPatchFeature(Codec<VegetationPatchConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225323_(WorldGenLevel worldGenLevel, VegetationPatchConfiguration vegetationPatchConfiguration, Predicate<BlockState> predicate, RandomSource random, BlockPos.MutableBlockPos mutableBlockPos, int i) {
        for (int j = 0; j < i; ++j) {
            BlockState currentPos;
            BlockState grassState = vegetationPatchConfiguration.f_161282_.m_213972_(random, (BlockPos)mutableBlockPos);
            if (grassState.m_60713_((currentPos = worldGenLevel.m_8055_((BlockPos)mutableBlockPos)).m_60734_())) continue;
            if (!predicate.test(currentPos)) {
                return j != 0;
            }
            if (!GrassPatchFeature.canBeGrass(grassState, (LevelReader)worldGenLevel, (BlockPos)mutableBlockPos)) {
                grassState = Blocks.f_50493_.m_49966_();
            }
            worldGenLevel.m_7731_((BlockPos)mutableBlockPos, grassState, 2);
            BlockPos belowPos = mutableBlockPos.m_7495_();
            BlockState belowState = worldGenLevel.m_8055_(belowPos);
            if (belowState.m_60713_(grassState.m_60734_()) && !GrassPatchFeature.canBeGrass(belowState, (LevelReader)worldGenLevel, belowPos)) {
                worldGenLevel.m_7731_(belowPos, Blocks.f_50493_.m_49966_(), 2);
            }
            mutableBlockPos.m_122173_(vegetationPatchConfiguration.f_161284_.m_162107_());
        }
        return true;
    }

    private static boolean canBeGrass(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.m_7494_();
        BlockState blockState2 = levelReader.m_8055_(blockPos2);
        if (blockState2.m_60713_(Blocks.f_50125_) && (Integer)blockState2.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockState2.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LightEngine.m_284282_((BlockGetter)levelReader, (BlockState)blockState, (BlockPos)blockPos, (BlockState)blockState2, (BlockPos)blockPos2, (Direction)Direction.UP, (int)blockState2.m_60739_((BlockGetter)levelReader, blockPos2));
        return i < levelReader.m_7469_();
    }
}

