/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.block;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import party.lemons.biomemakeover.block.IvyShapedBlock;
import party.lemons.biomemakeover.init.BMBlocks;

public class IvyBlock
extends IvyShapedBlock {
    public IvyBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Pair<Integer, Integer> nearbyCount = this.getNearbyIvyCount((Level)level, pos);
        if ((Integer)nearbyCount.getFirst() >= 6 && (Integer)nearbyCount.getSecond() >= 1) {
            return;
        }
        Direction checkDirection = this.getRandomStateSide(state, random);
        if (checkDirection == null) {
            return;
        }
        Direction direction = Direction.m_235672_((RandomSource)random);
        while (direction == checkDirection.m_122424_()) {
            direction = Direction.m_235672_((RandomSource)random);
        }
        BlockPos offsetPos = pos.m_121945_(direction);
        BlockState offsetState = level.m_8055_(offsetPos);
        BooleanProperty dirProperty = IvyBlock.getPropertyForDirection(direction);
        if (!((Boolean)state.m_61143_((Property)dirProperty)).booleanValue() && IvyBlock.isValidPlaceFace((LevelReader)level, direction, offsetPos, offsetState)) {
            if (this.hasAdjacentSide(direction, state)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)dirProperty, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (this.hasAdjacentSide(direction, state) && this.canReplace(offsetState)) {
            BlockState hitState;
            BlockPos hitPos = offsetPos.m_121945_(checkDirection);
            if (IvyBlock.isValidPlaceFace((LevelReader)level, direction, hitPos, hitState = level.m_8055_(hitPos))) {
                this.placeOrAddTo((Level)level, offsetPos, checkDirection);
                return;
            }
            BlockPos creepPos = pos.m_121945_(direction).m_121945_(checkDirection);
            BlockState creepState = level.m_8055_(creepPos);
            if (this.canReplace(creepState) && IvyBlock.isValidPlaceFace((LevelReader)level, direction, hitPos = pos.m_121945_(checkDirection), hitState = level.m_8055_(hitPos))) {
                this.placeOrAddTo((Level)level, creepPos, direction.m_122424_());
            }
        }
    }

    private void placeOrAddTo(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60713_((Block)this)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)IvyBlock.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(true)), 1);
        } else if (this.canReplace(state)) {
            world.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)IvyBlock.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(true)), 3);
            if (this.doesScheduleAfterSet()) {
                world.m_186460_(pos, (Block)this, this.getScheduleDelay());
            }
        }
    }

    protected boolean doesScheduleAfterSet() {
        return false;
    }

    protected int getScheduleDelay() {
        return 4;
    }

    private boolean canReplace(BlockState state) {
        return !state.m_204336_(BMBlocks.IVY_TAG) && (state.m_60795_() || state.m_60713_((Block)this) || state.m_247087_() && !state.m_278721_());
    }

    private Pair<Integer, Integer> getNearbyIvyCount(Level world, BlockPos pos) {
        int distance = 3;
        int count = -1;
        for (int x = -distance; x < distance; ++x) {
            for (int z = -distance; z < distance; ++z) {
                for (int y = -distance; y < distance; ++y) {
                    if (!world.m_8055_(pos.m_7918_(x, y, z)).m_60713_((Block)this)) continue;
                    ++count;
                }
            }
        }
        int adjacent = 0;
        for (Direction dir : Direction.values()) {
            if (!world.m_8055_(pos.m_121945_(dir)).m_60713_((Block)this)) continue;
            ++adjacent;
        }
        return new Pair((Object)count, (Object)adjacent);
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        return true;
    }
}

