/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.network;

import com.faboslav.friendsandfoes.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.init.FriendsAndFoesParticleTypes;
import com.faboslav.friendsandfoes.util.TotemUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class TotemEffectPacket {
    private final ItemStack itemStack;
    private final Entity entity;

    public TotemEffectPacket(FriendlyByteBuf buf) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        this.itemStack = buf.m_130267_();
        this.entity = minecraftClient.f_91073_.m_6815_(buf.readInt());
    }

    public TotemEffectPacket(ItemStack itemStack, Entity entity) {
        this.itemStack = itemStack;
        this.entity = entity;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        buf.writeInt(this.entity.m_19879_());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        if (this.itemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
            context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TotemUtil.playActivateAnimation(this.itemStack, this.entity, (ParticleOptions)FriendsAndFoesParticleTypes.TOTEM_OF_FREEZING)));
        } else if (this.itemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
            context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TotemUtil.playActivateAnimation(this.itemStack, this.entity, (ParticleOptions)FriendsAndFoesParticleTypes.TOTEM_OF_ILLUSION)));
        }
        context.get().setPacketHandled(true);
    }
}

