/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.entity.BlazeEntityAccess;
import com.faboslav.friendsandfoes.entity.WildfireEntity;
import com.faboslav.friendsandfoes.mixin.BlazeLivingEntityMixin;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Blaze.class})
public abstract class BlazeEntityMixin
extends BlazeLivingEntityMixin
implements BlazeEntityAccess {
    private static final String WILDFIRE_UUID_NBT_NAME = "WildfireUuid";
    private static final EntityDataAccessor<Optional<UUID>> WILDFIRE_UUID = SynchedEntityData.m_135353_(BlazeEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    protected BlazeEntityMixin(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"initDataTracker"})
    public void initDataTracker(CallbackInfo ci) {
        this.f_19804_.m_135372_(WILDFIRE_UUID, Optional.empty());
    }

    @Override
    public void friendsandfoes_writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        if (this.friendsandfoes_getWildfireUuid() != null) {
            nbt.m_128362_(WILDFIRE_UUID_NBT_NAME, this.friendsandfoes_getWildfireUuid());
        }
    }

    @Override
    public void friendsandfoes_readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128403_(WILDFIRE_UUID_NBT_NAME)) {
            this.friendsandfoes_setWildfireUuid(nbt.m_128342_(WILDFIRE_UUID_NBT_NAME));
        }
    }

    @Override
    public void friendsandfoes_onDeath(DamageSource damageSource, CallbackInfo ci) {
        WildfireEntity wildfireEntity;
        if (this.m_9236_() instanceof ServerLevel && (wildfireEntity = this.friendsandfoes_getWildfire()) != null) {
            wildfireEntity.setSummonedBlazesCount(wildfireEntity.getSummonedBlazesCount() - 1);
        }
    }

    @Nullable
    public UUID friendsandfoes_getWildfireUuid() {
        return ((Optional)this.f_19804_.m_135370_(WILDFIRE_UUID)).orElse(null);
    }

    public void friendsandfoes_setWildfireUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(WILDFIRE_UUID, Optional.ofNullable(uuid));
    }

    @Override
    public void friendsandfoes_setWildfire(WildfireEntity wildfire) {
        this.friendsandfoes_setWildfireUuid(wildfire.m_20148_());
    }

    @Override
    @Nullable
    public WildfireEntity friendsandfoes_getWildfire() {
        try {
            ServerLevel serverWorld = (ServerLevel)this.m_9236_();
            UUID uUID = this.friendsandfoes_getWildfireUuid();
            return uUID == null ? null : (WildfireEntity)serverWorld.m_8791_(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }
}

