/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.init;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.api.MoobloomVariants;
import com.faboslav.friendsandfoes.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.entity.IceologerEntity;
import com.faboslav.friendsandfoes.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.entity.MaulerEntity;
import com.faboslav.friendsandfoes.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.entity.RascalEntity;
import com.faboslav.friendsandfoes.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.entity.WildfireEntity;
import com.faboslav.friendsandfoes.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.mixin.SpawnRestrictionAccessor;
import com.faboslav.friendsandfoes.platform.BiomeModifications;
import com.faboslav.friendsandfoes.platform.CustomSpawnGroup;
import com.faboslav.friendsandfoes.platform.RegistryHelper;
import com.faboslav.friendsandfoes.tag.FriendsAndFoesTags;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.levelgen.Heightmap;

public final class FriendsAndFoesEntityTypes {
    public static boolean previousUseChoiceTypeRegistrations = SharedConstants.f_136182_;
    public static final Supplier<EntityType<CopperGolemEntity>> COPPER_GOLEM;
    public static final Supplier<EntityType<GlareEntity>> GLARE;
    public static final Supplier<EntityType<IceologerEntity>> ICEOLOGER;
    public static final Supplier<EntityType<IceologerIceChunkEntity>> ICE_CHUNK;
    public static final Supplier<EntityType<MaulerEntity>> MAULER;
    public static final Supplier<EntityType<MoobloomEntity>> MOOBLOOM;
    public static final Supplier<EntityType<RascalEntity>> RASCAL;
    public static final Supplier<EntityType<TuffGolemEntity>> TUFF_GOLEM;
    public static final Supplier<EntityType<WildfireEntity>> WILDFIRE;
    public static final Supplier<EntityType<PlayerIllusionEntity>> PLAYER_ILLUSION;

    public static void init() {
        FriendsAndFoesEntityTypes.createMobAttributes();
    }

    public static void postInit() {
        FriendsAndFoesEntityTypes.initSpawnRestrictions();
        FriendsAndFoesEntityTypes.addSpawns();
        FriendsAndFoesEntityTypes.addMoobloomVariants();
    }

    public static void createMobAttributes() {
        RegistryHelper.registerEntityAttribute(COPPER_GOLEM, CopperGolemEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(GLARE, GlareEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(ICEOLOGER, IceologerEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(MAULER, MaulerEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(MOOBLOOM, Cow::m_28307_);
        RegistryHelper.registerEntityAttribute(RASCAL, RascalEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(TUFF_GOLEM, TuffGolemEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(WILDFIRE, WildfireEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(PLAYER_ILLUSION, Mob::m_21552_);
    }

    public static void initSpawnRestrictions() {
        SpawnRestrictionAccessor.callRegister(GLARE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GlareEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister(ICEOLOGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
        SpawnRestrictionAccessor.callRegister(MAULER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MaulerEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister(MOOBLOOM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoobloomEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister(RASCAL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RascalEntity::canSpawn);
    }

    public static void addSpawns() {
        FriendsAndFoesConfig config = FriendsAndFoes.getConfig();
        if (config.enableGlare && config.enableGlareSpawn) {
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_GLARE, GLARE.get(), CustomSpawnGroup.getGlaresCategory(), config.glareSpawnWeight, config.glareSpawnMinGroupSize, config.glareSpawnMaxGroupSize);
        }
        if (config.enableMauler && config.enableMaulerSpawn) {
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_BADLANDS_MAULER, MAULER.get(), MobCategory.CREATURE, config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_DESERT_MAULER, MAULER.get(), MobCategory.CREATURE, config.maulerDesertSpawnWeight, config.maulerDesertSpawnMinGroupSize, config.maulerDesertSpawnMaxGroupSize);
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_SAVANNA_MAULER, MAULER.get(), MobCategory.CREATURE, config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
        }
        if (config.enableMoobloom && config.enableMoobloomSpawn) {
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_LESS_MOOBLOOMS, MOOBLOOM.get(), MobCategory.CREATURE, config.moobloomFlowerForestSpawnWeight, config.moobloomFlowerForestSpawnMinGroupSize, config.moobloomFlowerForestSpawnMaxGroupSize);
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_MORE_MOOBLOOMS, MOOBLOOM.get(), MobCategory.CREATURE, config.moobloomMeadowSpawnWeight, config.moobloomMeadowSpawnMinGroupSize, config.moobloomMeadowSpawnMaxGroupSize);
        }
        if (config.enableRascal && config.enableRascalSpawn) {
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_RASCAL, RASCAL.get(), CustomSpawnGroup.getRascalsCategory(), 4, 1, 1);
        }
    }

    public static void addMoobloomVariants() {
        MoobloomVariants.add("buttercup", (BushBlock)FriendsAndFoesBlocks.BUTTERCUP.get());
    }

    private FriendsAndFoesEntityTypes() {
    }

    static {
        SharedConstants.f_136182_ = false;
        COPPER_GOLEM = RegistryHelper.registerEntityType("copper_golem", () -> EntityType.Builder.m_20704_(CopperGolemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 1.375f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("copper_golem")));
        GLARE = RegistryHelper.registerEntityType("glare", () -> EntityType.Builder.m_20704_(GlareEntity::new, (MobCategory)CustomSpawnGroup.getGlaresCategory()).m_20699_(0.875f, 1.4375f).m_20702_(8).m_20717_(2).m_20712_(FriendsAndFoes.makeStringID("glare")));
        ICEOLOGER = RegistryHelper.registerEntityType("iceologer", () -> EntityType.Builder.m_20704_(IceologerEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("iceologer")));
        ICE_CHUNK = RegistryHelper.registerEntityType("ice_chunk", () -> EntityType.Builder.m_20704_(IceologerIceChunkEntity::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(2.5f, 1.0f).m_20702_(6).m_20712_(FriendsAndFoes.makeStringID("ice_chunk")));
        MAULER = RegistryHelper.registerEntityType("mauler", () -> EntityType.Builder.m_20704_(MaulerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5625f, 0.5625f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("mauler")));
        MOOBLOOM = RegistryHelper.registerEntityType("moobloom", () -> EntityType.Builder.m_20704_(MoobloomEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("moobloom")));
        RASCAL = RegistryHelper.registerEntityType("rascal", () -> EntityType.Builder.m_20704_(RascalEntity::new, (MobCategory)CustomSpawnGroup.getRascalsCategory()).m_20699_(0.9f, 1.25f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("rascal")));
        TUFF_GOLEM = RegistryHelper.registerEntityType("tuff_golem", () -> EntityType.Builder.m_20704_(TuffGolemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 1.0625f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("tuff_golem")));
        WILDFIRE = RegistryHelper.registerEntityType("wildfire", () -> EntityType.Builder.m_20704_(WildfireEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.12f, 3.0f).m_20702_(10).m_20719_().m_20712_(FriendsAndFoes.makeStringID("wildfire")));
        PLAYER_ILLUSION = RegistryHelper.registerEntityType("player_illusion", () -> EntityType.Builder.m_20704_(PlayerIllusionEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.7f, 1.875f).m_20702_(10).m_20719_().m_20712_(FriendsAndFoes.makeStringID("player_illusion")));
        SharedConstants.f_136182_ = previousUseChoiceTypeRegistrations;
    }
}

