/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal.coppergolem;

import com.faboslav.friendsandfoes.block.CopperButtonBlock;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.tag.FriendsAndFoesTags;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public final class CopperGolemPressButtonGoal
extends Goal {
    private final int COPPER_BUTTON_SEARCH_DISTANCE = 8;
    private final CopperGolemEntity copperGolem;
    private BlockPos copperButtonToPress;
    private BlockPos positionToStandOn;
    private BlockPos positionToLookAt;
    private Path currentPath;
    private int standingNearToCopperButtonTicks;
    private int idleTicksBeforeButtonPress;
    private int idleTicksAfterButtonPress;
    private int ticksAfterButtonPress;
    private boolean isRunning;
    private int runTicks;
    private boolean copperButtonWasSuccessfullyPressed;

    public CopperGolemPressButtonGoal(CopperGolemEntity copperGolem) {
        this.copperGolem = copperGolem;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.copperGolem.getTicksUntilCanPressButton() > 0) {
            return false;
        }
        if (this.copperGolem.isOxidized()) {
            return false;
        }
        if (this.copperGolem.m_21573_().m_26572_()) {
            return false;
        }
        if (this.copperGolem.isSpinningHead()) {
            return false;
        }
        ArrayList<BlockPos> copperButtons = this.findCopperButtons();
        this.copperButtonToPress = this.getRandomCopperButtonToPress(copperButtons);
        if (this.copperButtonToPress == null) {
            return false;
        }
        this.calculatePositionToStandOn();
        this.calculatePositionToLookAt();
        return this.positionToStandOn != null && this.positionToLookAt != null;
    }

    public boolean m_8045_() {
        if (this.copperGolem.isOxidized()) {
            return false;
        }
        if (this.runTicks >= 900) {
            return false;
        }
        if (this.copperButtonWasSuccessfullyPressed && this.ticksAfterButtonPress >= this.idleTicksAfterButtonPress) {
            return false;
        }
        if (this.copperButtonToPress == null || this.positionToStandOn == null || this.positionToLookAt == null) {
            return false;
        }
        BlockState copperButtonBlockState = this.getCopperButtonBlockState(this.copperButtonToPress);
        return copperButtonBlockState != null;
    }

    public void m_8056_() {
        this.isRunning = true;
        this.runTicks = 0;
        this.standingNearToCopperButtonTicks = 0;
        this.ticksAfterButtonPress = 0;
        this.copperButtonWasSuccessfullyPressed = false;
        int minIdleTicks = 20;
        int maxIdleTicks = 40;
        this.idleTicksBeforeButtonPress = this.copperGolem.m_217043_().m_216332_(minIdleTicks, maxIdleTicks);
        this.idleTicksAfterButtonPress = this.copperGolem.m_217043_().m_216332_(minIdleTicks, maxIdleTicks);
    }

    public void m_8041_() {
        this.isRunning = false;
        this.copperButtonToPress = null;
        this.positionToStandOn = null;
        this.positionToLookAt = null;
        this.currentPath = null;
        this.copperGolem.setIsPressingButton(false);
        int minCooldownTicks = 200;
        if (this.copperGolem.isDegraded()) {
            minCooldownTicks *= this.copperGolem.getOxidationLevel().ordinal();
        }
        int maxCooldownTicks = minCooldownTicks + 200;
        int cooldown = this.copperGolem.m_217043_().m_216332_(minCooldownTicks, maxCooldownTicks);
        this.copperGolem.setTicksUntilCanPressButton(cooldown);
    }

    public void m_8037_() {
        ++this.runTicks;
        PathNavigation navigation = this.copperGolem.m_21573_();
        double distanceToButton = this.copperGolem.m_20182_().m_82531_((double)this.positionToStandOn.m_123341_(), (double)this.positionToStandOn.m_123342_(), (double)this.positionToStandOn.m_123343_());
        if (this.currentPath == null) {
            this.currentPath = navigation.m_26524_((double)this.positionToStandOn.m_123341_(), (double)this.positionToStandOn.m_123342_(), (double)this.positionToStandOn.m_123343_(), 0);
        }
        if (this.currentPath != null) {
            this.copperGolem.m_21573_().m_26536_(this.currentPath, (double)this.copperGolem.m_6113_());
        }
        if (distanceToButton <= 3.0) {
            this.copperGolem.m_21563_().m_24946_((double)this.positionToLookAt.m_123341_(), (double)this.positionToLookAt.m_123342_(), (double)this.positionToLookAt.m_123343_());
        }
        if (distanceToButton >= 1.5) {
            if (this.copperGolem.isPressingButton()) {
                this.copperGolem.setIsPressingButton(false);
            }
            return;
        }
        ++this.standingNearToCopperButtonTicks;
        if (this.standingNearToCopperButtonTicks >= this.idleTicksBeforeButtonPress / 3 && !this.copperGolem.isPressingButton()) {
            this.copperGolem.setIsPressingButton(true);
        }
        if (this.standingNearToCopperButtonTicks <= this.idleTicksBeforeButtonPress) {
            return;
        }
        if (!this.copperButtonWasSuccessfullyPressed) {
            this.copperButtonWasSuccessfullyPressed = this.pressCopperButton();
        } else {
            ++this.ticksAfterButtonPress;
        }
    }

    private boolean pressCopperButton() {
        BlockState copperButtonBlockState = this.getCopperButtonBlockState(this.copperButtonToPress);
        if (copperButtonBlockState == null) {
            return false;
        }
        if (((Boolean)copperButtonBlockState.m_61143_((Property)CopperButtonBlock.f_51045_)).booleanValue()) {
            return false;
        }
        CopperButtonBlock copperButtonBlock = (CopperButtonBlock)copperButtonBlockState.m_60734_();
        copperButtonBlock.m_51116_(copperButtonBlockState, this.copperGolem.m_20193_(), this.copperButtonToPress);
        this.copperGolem.m_20193_().m_5594_(null, this.copperButtonToPress, copperButtonBlock.m_5722_(true), SoundSource.BLOCKS, 0.3f, 0.6f);
        this.copperGolem.m_20193_().m_142346_((Entity)this.copperGolem, GameEvent.f_223702_, this.copperButtonToPress);
        return true;
    }

    private ArrayList<BlockPos> findCopperButtons() {
        int horizontalSearchDistance = 8;
        int verticalSearchDistance = 4;
        Level world = this.copperGolem.m_9236_();
        BlockPos currentPosition = this.copperGolem.m_20183_();
        ArrayList<BlockPos> copperButtonBlocks = new ArrayList<BlockPos>();
        for (int xPosition = -horizontalSearchDistance; xPosition <= horizontalSearchDistance; ++xPosition) {
            for (int zPosition = -horizontalSearchDistance; zPosition <= horizontalSearchDistance; ++zPosition) {
                for (int yPosition = -verticalSearchDistance; yPosition <= verticalSearchDistance; ++yPosition) {
                    BlockPos.MutableBlockPos mutableBlockPosition = new BlockPos.MutableBlockPos();
                    mutableBlockPosition.m_122178_(currentPosition.m_123341_() + xPosition, currentPosition.m_123342_() + yPosition, currentPosition.m_123343_() + zPosition);
                    if (!world.m_8055_((BlockPos)mutableBlockPosition).m_204336_(FriendsAndFoesTags.COPPER_BUTTONS)) continue;
                    copperButtonBlocks.add((BlockPos)mutableBlockPosition);
                }
            }
        }
        return copperButtonBlocks;
    }

    @Nullable
    private BlockPos getRandomCopperButtonToPress(ArrayList<BlockPos> copperButtons) {
        int copperButtonsCount = copperButtons.size();
        if (copperButtonsCount == 0) {
            return null;
        }
        int randomCopperButtonIndex = this.copperGolem.m_217043_().m_216332_(0, copperButtonsCount - 1);
        return copperButtons.get(randomCopperButtonIndex);
    }

    private void calculatePositionToStandOn() {
        BlockState copperButtonBlockState = this.getCopperButtonBlockState(this.copperButtonToPress);
        if (copperButtonBlockState == null) {
            return;
        }
        BlockPos positionToStandOn = null;
        Direction direction = (Direction)copperButtonBlockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        ServerLevel serverWorld = (ServerLevel)this.copperGolem.m_20193_();
        switch (direction) {
            case DOWN: {
                if (!serverWorld.m_46859_(this.copperButtonToPress.m_7495_()) || !serverWorld.m_8055_(this.copperButtonToPress.m_6625_(2)).m_60634_((BlockGetter)serverWorld, this.copperButtonToPress, (Entity)this.copperGolem)) break;
                positionToStandOn = this.copperButtonToPress.m_7918_(0, -2, 0);
                break;
            }
            case UP: {
                if (!serverWorld.m_8055_(this.copperButtonToPress.m_6625_(1)).m_60634_((BlockGetter)serverWorld, this.copperButtonToPress, (Entity)this.copperGolem) || !serverWorld.m_46859_(this.copperButtonToPress.m_7494_())) break;
                positionToStandOn = this.copperButtonToPress;
                break;
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                if (serverWorld.m_46859_(this.copperButtonToPress.m_7495_()) && serverWorld.m_8055_(this.copperButtonToPress.m_6625_(2)).m_60634_((BlockGetter)serverWorld, this.copperButtonToPress, (Entity)this.copperGolem)) {
                    positionToStandOn = this.copperButtonToPress.m_7918_(0, -1, 0);
                    break;
                }
                if (!serverWorld.m_46859_(this.copperButtonToPress.m_7494_()) || !serverWorld.m_8055_(this.copperButtonToPress.m_7495_()).m_60634_((BlockGetter)serverWorld, this.copperButtonToPress, (Entity)this.copperGolem)) break;
                positionToStandOn = this.copperButtonToPress;
            }
        }
        this.positionToStandOn = positionToStandOn;
    }

    private void calculatePositionToLookAt() {
        BlockState copperButtonBlockState = this.getCopperButtonBlockState(this.copperButtonToPress);
        if (copperButtonBlockState == null) {
            return;
        }
        BlockPos positionToLookAt = this.copperButtonToPress;
        Direction direction = (Direction)copperButtonBlockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        this.positionToLookAt = positionToLookAt = (switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> positionToLookAt;
            case Direction.NORTH -> positionToLookAt.m_7918_(0, 0, 1);
            case Direction.EAST -> positionToLookAt.m_7918_(-1, 0, 0);
            case Direction.SOUTH -> positionToLookAt.m_7918_(0, 0, -1);
            case Direction.WEST -> positionToLookAt.m_7918_(1, 0, 0);
        });
    }

    @Nullable
    private BlockState getCopperButtonBlockState(BlockPos copperButtonBlockPos) {
        ServerLevel serverWorld = (ServerLevel)this.copperGolem.m_20193_();
        BlockState blockState = serverWorld.m_8055_(copperButtonBlockPos);
        if (blockState.m_60734_() instanceof CopperButtonBlock) {
            return blockState;
        }
        return null;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

