/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.model;

import com.faboslav.friendsandfoes.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.util.ModelAnimationHelper;
import com.faboslav.friendsandfoes.util.animation.AnimationMath;
import net.minecraft.client.model.ModelUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class CopperGolemEntityModel<T extends CopperGolemEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_LEFT_ARM = "leftArm";
    private static final String MODEL_PART_RIGHT_ARM = "rightArm";
    private static final String MODEL_PART_LEFT_LEG = "leftLeg";
    private static final String MODEL_PART_RIGHT_LEG = "rightLeg";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_NOSE = "nose";
    private static final String MODEL_PART_ROD = "rod";
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart rod;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private float buttonPressAnimationProgress;
    private float headSpinAnimationProgress;

    public CopperGolemEntityModel(ModelPart root) {
        super(root);
        this.head = this.root.m_171324_(MODEL_PART_HEAD);
        this.nose = this.head.m_171324_(MODEL_PART_NOSE);
        this.rod = this.head.m_171324_(MODEL_PART_ROD);
        this.body = this.root.m_171324_(MODEL_PART_BODY);
        this.leftArm = this.root.m_171324_(MODEL_PART_LEFT_ARM);
        this.rightArm = this.root.m_171324_(MODEL_PART_RIGHT_ARM);
        this.leftLeg = this.root.m_171324_(MODEL_PART_LEFT_LEG);
        this.rightLeg = this.root.m_171324_(MODEL_PART_RIGHT_LEG);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.m_171576_();
        root.m_171599_(MODEL_PART_HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition head = root.m_171597_(MODEL_PART_HEAD);
        head.m_171599_(MODEL_PART_NOSE, CubeListBuilder.m_171558_().m_171514_(56, 15).m_171481_(-1.0f, -1.0f, -2.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.0f));
        head.m_171599_(MODEL_PART_ROD, CubeListBuilder.m_171558_().m_171514_(56, 10).m_171481_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f).m_171514_(40, 9).m_171481_(-2.0f, -7.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_BODY, CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 5.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_LEFT_ARM, CubeListBuilder.m_171558_().m_171514_(10, 17).m_171481_(0.0f, -1.0f, -1.5f, 2.0f, 10.0f, 3.0f), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_RIGHT_ARM, CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-2.0f, -1.0f, -1.5f, 2.0f, 10.0f, 3.0f), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_LEFT_LEG, CubeListBuilder.m_171558_().m_171514_(34, 17).m_171481_(-2.0f, 0.0f, -1.5f, 4.0f, 5.0f, 3.0f), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_RIGHT_LEG, CubeListBuilder.m_171558_().m_171514_(20, 17).m_171481_(-2.0f, 0.0f, -1.5f, 4.0f, 5.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setAngles(T copperGolem, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (((CopperGolemEntity)copperGolem).isOxidized()) {
            CompoundTag modelAngles = ((CopperGolemEntity)copperGolem).getEntitySnapshot();
            float tickDelta = modelAngles.m_128457_("tickDelta");
            limbAngle = modelAngles.m_128457_("limbAngle");
            limbDistance = modelAngles.m_128457_("lastLimbDistance");
            animationProgress = ModelAnimationHelper.getAnimationProgress(copperGolem, tickDelta);
        } else if (((CopperGolemEntity)copperGolem).f_20916_ == 0) {
            limbDistance = (float)((double)limbDistance * 1.5);
            limbAngle = (float)((double)limbAngle * 1.5);
        }
        this.applyModelTransforms("root", this.root);
        float headSpinAnimationProgress = ((CopperGolemEntity)copperGolem).getHeadSpinAnimationProgress();
        this.rightLeg.f_104203_ = -1.5f * Mth.m_14156_((float)limbAngle, (float)13.0f) * limbDistance;
        this.leftLeg.f_104203_ = 1.5f * Mth.m_14156_((float)limbAngle, (float)13.0f) * limbDistance;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
        if (headSpinAnimationProgress > 0.0f && headSpinAnimationProgress <= 1.0f) {
            this.head.f_104204_ = (float)Mth.m_14139_((double)this.headSpinAnimationProgress, (double)0.0, (double)(Math.PI * 2));
        } else {
            this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        }
        if (((CopperGolemEntity)copperGolem).getButtonPressAnimationProgress() > 0.0f) {
            if (((CopperGolemEntity)copperGolem).getButtonPressAnimationProgress() == 1.0f) {
                this.leftArm.f_104203_ = (float)Math.toRadians(-180.0f + 30.0f * Mth.m_14154_((float)Mth.m_14031_((float)(animationProgress * 0.5f))));
                this.rightArm.f_104203_ = (float)Math.toRadians(-180.0f + 30.0f * Mth.m_14154_((float)Mth.m_14089_((float)(animationProgress * 0.5f))));
                this.leftArm.f_104205_ = (float)Math.toRadians(20.0);
                this.rightArm.f_104205_ = (float)Math.toRadians(-20.0);
            } else {
                this.leftArm.f_104203_ = ModelUtils.m_103125_((float)this.leftArm.f_104203_, (float)((float)Math.toRadians(-165.0)), (float)this.buttonPressAnimationProgress);
                this.rightArm.f_104203_ = ModelUtils.m_103125_((float)this.rightArm.f_104203_, (float)((float)Math.toRadians(-165.0)), (float)this.buttonPressAnimationProgress);
                this.leftArm.f_104205_ = ModelUtils.m_103125_((float)this.leftArm.f_104205_, (float)((float)Math.toRadians(20.0)), (float)this.buttonPressAnimationProgress);
                this.rightArm.f_104205_ = ModelUtils.m_103125_((float)this.rightArm.f_104205_, (float)((float)Math.toRadians(-20.0)), (float)this.buttonPressAnimationProgress);
            }
        } else {
            this.leftArm.f_104203_ = (-0.2f + 1.5f * Mth.m_14156_((float)limbAngle, (float)13.0f)) * limbDistance;
            this.rightArm.f_104203_ = (-0.2f - 1.5f * Mth.m_14156_((float)limbAngle, (float)13.0f)) * limbDistance;
        }
        float defaultRodPivotY = this.rod.f_104201_;
        if (copperGolem.m_20096_() && ((CopperGolemEntity)copperGolem).isMoving() && !((CopperGolemEntity)copperGolem).isOxidized()) {
            float rodPivotY = defaultRodPivotY + AnimationMath.absSin(animationProgress, 1.0f, 0.25f);
            this.animateModelPartYPositionBasedOnProgress((AnimatedEntity)copperGolem, this.rod, rodPivotY, AnimationMath.absSin(animationProgress));
        } else {
            CopperGolemEntityModel.animateModelPartYPositionBasedOnTicks(copperGolem, this.rod, defaultRodPivotY, 10);
        }
    }

    public void animateModel(T copperGolem, float limbAngle, float limbDistance, float tickDelta) {
        if (((CopperGolemEntity)copperGolem).isOxidized()) {
            CompoundTag modelAngles = ((CopperGolemEntity)copperGolem).getEntitySnapshot();
            tickDelta = modelAngles.m_128457_("tickDelta");
        }
        this.buttonPressAnimationProgress = ((CopperGolemEntity)copperGolem).getLastButtonPressAnimationProgress() + (((CopperGolemEntity)copperGolem).getButtonPressAnimationProgress() - ((CopperGolemEntity)copperGolem).getLastButtonPressAnimationProgress()) * tickDelta;
        this.headSpinAnimationProgress = ((CopperGolemEntity)copperGolem).getLastHeadSpinAnimationProgress() + (((CopperGolemEntity)copperGolem).getHeadSpinAnimationProgress() - ((CopperGolemEntity)copperGolem).getLastHeadSpinAnimationProgress()) * tickDelta;
    }
}

