/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.world.entity.projectile.Cannon;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.item.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface Cannonable
extends Ability {
    public float getDefaultCannonPower();

    public CannonPosition getCannonPosition(int var1);

    public byte getMaxCannonPerSide();

    default public void tickCannonShip() {
        for (Cannon cannon : this.self().CANNONS) {
            cannon.m_8119_();
            if (!this.self().isCannonKeyPressed() || !this.canShoot() || !cannon.canShootDirection()) continue;
            cannon.trigger();
        }
    }

    default public void defineCannonShipSynchedData() {
        this.self().m_20088_().m_135372_(Ship.CANNON_POWER, (Object)Float.valueOf(this.getDefaultCannonPower()));
        this.self().m_20088_().m_135372_(Ship.CANNON_COUNT, (Object)0);
    }

    default public void readCannonShipSaveData(CompoundTag tag) {
        if (tag.m_128441_("CannonCount")) {
            this.self().setCannonCount(tag.m_128445_("CannonCount"));
            this.updateCannonCount();
        }
    }

    default public void addCannonShipSaveData(CompoundTag tag) {
        tag.m_128405_("CannonCount", (int)this.self().getCannonCount());
    }

    default public float getCannonModifier() {
        return (float)this.self().getCannonCount() * 0.025f;
    }

    default public void updateCannonCount() {
        int cannons = this.self().getCannonCount();
        this.self().CANNONS.clear();
        for (int i = 0; i < cannons; ++i) {
            CannonPosition cannonPosition = this.getCannonPosition(i);
            if (cannonPosition == null) continue;
            Cannon cannon = new Cannon(this.self(), cannonPosition);
            this.self().CANNONS.add(cannon);
        }
        this.self().setCannonCount((byte)cannons);
    }

    default public boolean interactCannon(Player player, InteractionHand interactionHand) {
        ItemStack item = player.m_21120_(interactionHand);
        byte cannons = this.self().getCannonCount();
        if (item.m_41720_() == ModItems.CANNON && this.self() instanceof ContainerShip) {
            if (cannons >= this.getMaxCannonPerSide() * 2) {
                return false;
            }
            this.self().setCannonCount((byte)(cannons + 1));
            this.self().m_9236_().m_6263_(player, this.self().m_20185_(), this.self().m_20186_() + 4.0, this.self().m_20189_(), SoundEvents.f_11672_, this.self().m_5720_(), 15.0f, 1.5f);
            if (!player.m_7500_()) {
                item.m_41774_(1);
            }
            this.updateCannonCount();
            return true;
        }
        if (item.m_41720_() instanceof AxeItem && cannons > 0) {
            this.self().setCannonCount((byte)(cannons - 1));
            this.self().m_19998_((ItemLike)ModItems.CANNON);
            this.self().m_9236_().m_6263_(player, this.self().m_20185_(), this.self().m_20186_() + 4.0, this.self().m_20189_(), SoundEvents.f_11672_, this.self().m_5720_(), 15.0f, 1.0f);
            return true;
        }
        return false;
    }

    default public boolean canShoot() {
        Ship ship = this.self();
        if (ship instanceof ContainerEntity) {
            ContainerEntity containerEntity = (ContainerEntity)ship;
            return containerEntity.m_213659_().stream().anyMatch(itemStack -> itemStack.m_41720_().equals(ModItems.CANNON_BALL));
        }
        ship = this.self().m_6688_();
        if (ship instanceof Player) {
            Player player = (Player)ship;
            return player.m_150109_().f_35974_.stream().anyMatch(itemStack -> itemStack.m_41720_().equals(ModItems.CANNON_BALL));
        }
        return false;
    }

    default public void consumeCannonBall() {
        block2: {
            Object object;
            block3: {
                object = this.self();
                if (!(object instanceof ContainerEntity)) break block3;
                ContainerEntity containerEntity = (ContainerEntity)object;
                for (ItemStack itemstack : containerEntity.m_213659_()) {
                    if (!itemstack.m_150930_(ModItems.CANNON_BALL)) continue;
                    itemstack.m_41774_(1);
                    break block2;
                }
                break block2;
            }
            object = this.self().m_6688_();
            if (!(object instanceof Player)) break block2;
            Player player = (Player)object;
            for (ItemStack itemstack : player.m_150109_().f_35974_) {
                if (!itemstack.m_150930_(ModItems.CANNON_BALL)) continue;
                itemstack.m_41774_(1);
                break;
            }
        }
    }

    default public ResourceLocation getTextureLocation() {
        return new ResourceLocation("smallships", "textures/entity/cannon/ship_cannon.png");
    }

    public static class CannonPosition {
        public final double x;
        public final double y;
        public final double z;
        public final boolean isRightSided;

        public CannonPosition(double x, double y, double z, boolean isRightSided) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.isRightSided = isRightSided;
        }
    }
}

