/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.mixin.controlling.BoatAccessor;
import com.talhanation.smallships.world.entity.ModEntityTypes;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Leashable;
import com.talhanation.smallships.world.entity.ship.abilities.Repairable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.item.ModItems;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogEntity
extends ContainerShip
implements Bannerable,
Sailable,
Cannonable,
Repairable,
Leashable {
    public static final String ID = "cog";
    private static final int ORIGINAL_CONTAINER_SIZE = (Integer)SmallShipsConfig.Common.shipContainerCogContainerSize.get();

    public CogEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level, ORIGINAL_CONTAINER_SIZE);
    }

    private CogEntity(Level level, double d, double e, double f) {
        this(ModEntityTypes.COG, level);
        this.m_6034_(d, e, f);
        this.f_19854_ = d;
        this.f_19855_ = e;
        this.f_19856_ = f;
    }

    public static CogEntity summon(Level level, double d, double e, double f) {
        return new CogEntity(level, d, e, f);
    }

    @Override
    public CompoundTag createDefaultAttributes() {
        Attributes attributes = new Attributes();
        attributes.maxHealth = ((Double)SmallShipsConfig.Common.shipAttributeCogMaxHealth.get()).floatValue();
        attributes.maxSpeed = ((Double)SmallShipsConfig.Common.shipAttributeCogMaxSpeed.get()).floatValue();
        attributes.maxReverseSpeed = ((Double)SmallShipsConfig.Common.shipAttributeCogMaxReverseSpeed.get()).floatValue();
        attributes.maxRotationSpeed = ((Double)SmallShipsConfig.Common.shipAttributeCogMaxRotationSpeed.get()).floatValue();
        attributes.acceleration = ((Double)SmallShipsConfig.Common.shipAttributeCogAcceleration.get()).floatValue();
        attributes.rotationAcceleration = ((Double)SmallShipsConfig.Common.shipAttributeCogRotationAcceleration.get()).floatValue();
        CompoundTag tag = new CompoundTag();
        attributes.addSaveData(tag);
        return tag;
    }

    @Override
    protected int m_213801_() {
        return 5;
    }

    @Override
    @NotNull
    public Item m_38369_() {
        if (!((Boolean)SmallShipsConfig.Common.shipGeneralDoItemDrop.get()).booleanValue()) {
            return ItemStack.f_41583_.m_41720_();
        }
        return ModItems.COG_ITEMS.get(this.m_28554_());
    }

    @Override
    public int getBiomesModifierType() {
        return (Integer)SmallShipsConfig.Common.shipModifierCogBiome.get();
    }

    public void m_7332_(@NotNull Entity entity) {
        if (this.m_20363_(entity)) {
            float d = this.m_213802_();
            float e = 0.0f;
            float f = 0.0f;
            float g = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + entity.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(entity);
                switch (i) {
                    case 0: {
                        d = -2.25f;
                        f = 0.0f;
                        break;
                    }
                    case 1: {
                        d = -0.9f;
                        f = 0.9f;
                        break;
                    }
                    case 2: {
                        d = -0.9f;
                        f = -0.9f;
                        break;
                    }
                    case 3: {
                        d = 0.65f;
                        f = -0.75f;
                        break;
                    }
                    case 4: {
                        d = 0.65f;
                        f = 0.75f;
                        break;
                    }
                    default: {
                        d = 1.5f;
                        f = 0.0f;
                    }
                }
            }
            Vec3 vec3 = new Vec3((double)d, (double)e, (double)f).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            entity.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)g, this.m_20189_() + vec3.f_82481_);
            entity.m_146922_(entity.m_146908_() + ((BoatAccessor)((Object)this)).getDeltaRotation());
            entity.m_5616_(entity.m_6080_() + ((BoatAccessor)((Object)this)).getDeltaRotation());
            this.m_38321_(entity);
            if (entity instanceof Animal && this.m_20197_().size() == this.m_213801_()) {
                int j = entity.m_19879_() % 2 == 0 ? 90 : 270;
                entity.m_5618_(((Animal)entity).f_20883_ + (float)j);
                entity.m_5616_(entity.m_6080_() + (float)j);
            }
        }
    }

    @Override
    public Cannonable.CannonPosition getCannonPosition(int index) {
        ArrayList<Cannonable.CannonPosition> positionList = new ArrayList<Cannonable.CannonPosition>();
        Cannonable.CannonPosition pos1 = new Cannonable.CannonPosition(1.4, 0.2, 0.6, true);
        Cannonable.CannonPosition pos2 = new Cannonable.CannonPosition(1.4, 0.2, 0.6, false);
        Cannonable.CannonPosition pos3 = new Cannonable.CannonPosition(-0.6, 0.2, 0.6, true);
        Cannonable.CannonPosition pos4 = new Cannonable.CannonPosition(-0.6, 0.2, 0.6, false);
        positionList.add(pos1);
        positionList.add(pos2);
        positionList.add(pos3);
        positionList.add(pos4);
        return (Cannonable.CannonPosition)positionList.get(index);
    }

    @Override
    public byte getMaxCannonPerSide() {
        return 2;
    }

    protected float m_213802_() {
        return -1.75f;
    }

    @Override
    public Bannerable.BannerPosition getBannerPosition() {
        return new Bannerable.BannerPosition(-180.0f, 90.0f, -4.0, 0.78, 0.05);
    }

    @Override
    public float getDefaultCannonPower() {
        return 4.0f;
    }

    @Override
    public void waterSplash() {
        Vec3 vector3d = this.m_20252_(0.0f);
        float f0 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.8f;
        float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.8f;
        float f0_1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.6f;
        float f1_1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.6f;
        float f2 = 2.5f - this.f_19796_.m_188501_() * 0.7f;
        float f2_ = -1.3f - this.f_19796_.m_188501_() * 0.7f;
        float x = 0.0f;
        for (int i = 0; i < 2; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vector3d.f_82479_ * (double)f2 + (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.5, this.m_20189_() - vector3d.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vector3d.f_82479_ * (double)f2 - (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.5, this.m_20189_() - vector3d.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vector3d.f_82479_ * (double)f2 + (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.5, this.m_20189_() - vector3d.f_82481_ * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vector3d.f_82479_ * (double)f2 - (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.5, this.m_20189_() - vector3d.f_82481_ * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2 + (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2 - (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2 + (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2 - (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ + (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) + (double)f1_1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ - (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) - (double)f1_1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ + (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) + (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ - (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) - (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ + (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) + (double)f1_1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ - (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) - (double)f1_1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ + (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) + (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ - (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) - (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Nullable
    public Vec3 applyLeashOffset() {
        return new Vec3(0.0, (double)this.m_20192_(), (double)(this.m_20205_() * 0.1f));
    }
}

