/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.whatareyouvotingfor.entities;

import com.alexander.whatareyouvotingfor.init.ItemInit;
import com.alexander.whatareyouvotingfor.util.MiscUtils;
import com.alexander.whatareyouvotingfor.util.PositionUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Crab
extends Animal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> CLAW_SIZE = SynchedEntityData.m_135353_(Crab.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int clawGrowTime = 20;
    public AnimationState waveAnimationState = new AnimationState();
    public int waveAnimationTick;
    public final int waveAnimationLength = 42;
    public final int waveAnimationActionPoint = 19;
    public int climbPoseFor;
    public float targetYRotClimbing;
    public float targetXRotClimbing;
    public float yRotClimbing;
    public float xRotClimbing;
    public float targetYRotWalking;
    public float yRotWalking;
    public int climbCooldown;
    public Vec3 lastTickPos = Vec3.f_82478_;

    public Crab(EntityType<? extends Crab> type, Level level) {
        super(type, level);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.clawGrowTime = this.randomClawGrowTime();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new WaveGoal());
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<Crab> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_220864_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_220833_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_220834_)) && Crab.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return SoundEvents.f_12536_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12531_;
    }

    public float m_6100_() {
        return super.m_6100_() * 2.0f;
    }

    protected float m_6108_() {
        return this.m_20096_() ? 0.95f : super.m_6108_();
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 0.25f, 1.5f);
    }

    public int randomClawGrowTime() {
        return 6000 + this.f_19796_.m_188503_(6000);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(CLAW_SIZE, (Object)0);
    }

    public void m_7380_(CompoundTag p_27587_) {
        super.m_7380_(p_27587_);
        p_27587_.m_128405_("ClawGrowTime", this.clawGrowTime);
        p_27587_.m_128405_("ClawSize", this.getClawSize());
    }

    public void m_7378_(CompoundTag p_27576_) {
        super.m_7378_(p_27576_);
        this.clawGrowTime = p_27576_.m_128451_("ClawGrowTime");
        this.setClawSize(p_27576_.m_128451_("ClawSize"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean canClimb;
            boolean bl = canClimb = !this.m_9236_().m_45772_(this.m_20191_().m_82377_(0.2, -0.1, 0.2)) && this.climbCooldown <= 0 && (this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60795_() || this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_7494_()).m_83281_()) && (!this.m_9236_().m_8055_(this.m_20183_().m_122019_()).m_60795_() && !this.m_9236_().m_8055_(this.m_20183_().m_122019_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_122019_()).m_83281_() || !this.m_9236_().m_8055_(this.m_20183_().m_122024_()).m_60795_() && !this.m_9236_().m_8055_(this.m_20183_().m_122024_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_122024_()).m_83281_() || !this.m_9236_().m_8055_(this.m_20183_().m_122012_()).m_60795_() && !this.m_9236_().m_8055_(this.m_20183_().m_122012_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_122012_()).m_83281_() || !this.m_9236_().m_8055_(this.m_20183_().m_122029_()).m_60795_() && !this.m_9236_().m_8055_(this.m_20183_().m_122029_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_122029_()).m_83281_());
            if (this.isClimbing() && this.f_19797_ % 10 == 0 && (double)MiscUtils.distanceBetweenVecs(this.m_20182_(), this.lastTickPos) <= 0.1) {
                canClimb = false;
            }
            if (this.isClimbing() && !canClimb) {
                this.climbCooldown = 20;
            }
            this.setClimbing(canClimb);
        }
        this.lastTickPos = this.m_20182_();
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
            if (this.climbCooldown == 15 && !this.m_20096_()) {
                this.m_5997_(this.f_19796_.m_188583_() * 0.1, 0.0, this.f_19796_.m_188583_() * 0.1);
            }
        }
        if (this.isClimbing()) {
            this.climbPoseFor = 5;
            if (this.f_19797_ % 5 == 0) {
                this.m_7355_(this.m_20097_(), this.m_20075_());
            }
            Vec3 newMotion = new Vec3(0.0, 0.0, 0.0);
            if (!this.m_9236_().m_8055_(this.m_20183_().m_122019_()).m_60795_() && !this.m_9236_().m_8055_(this.m_20183_().m_122019_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_122019_()).m_83281_()) {
                newMotion = new Vec3(0.0, 0.2, 0.1);
            } else if (!this.m_9236_().m_8055_(this.m_20183_().m_122024_()).m_60795_() && !this.m_9236_().m_8055_(this.m_20183_().m_122024_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_122024_()).m_83281_()) {
                newMotion = new Vec3(-0.1, 0.2, 0.0);
            } else if (!this.m_9236_().m_8055_(this.m_20183_().m_122012_()).m_60795_() && !this.m_9236_().m_8055_(this.m_20183_().m_122012_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_122012_()).m_83281_()) {
                newMotion = new Vec3(0.0, 0.2, -0.1);
            } else if (!this.m_9236_().m_8055_(this.m_20183_().m_122029_()).m_60795_() && !this.m_9236_().m_8055_(this.m_20183_().m_122029_()).m_60812_((BlockGetter)this.m_9236_(), this.m_20183_().m_122029_()).m_83281_()) {
                newMotion = new Vec3(0.1, 0.2, 0.0);
            }
            this.m_20256_(newMotion);
        }
        if (this.climbPoseFor > 0) {
            --this.climbPoseFor;
            this.m_146922_(0.0f);
            this.m_5618_(0.0f);
            this.m_5616_(0.0f);
            this.f_19859_ = this.m_146908_();
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.tickDownAnimTimers();
        if (this.clawGrowTime > 0) {
            --this.clawGrowTime;
        } else {
            this.setClawSize(this.getClawSize() + 1);
        }
    }

    public void tickDownAnimTimers() {
        if (this.waveAnimationTick > 0) {
            --this.waveAnimationTick;
        }
        if (this.m_9236_().f_46443_ && this.waveAnimationTick <= 0) {
            this.waveAnimationState.m_216973_();
        }
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.waveAnimationTick = this.waveAnimationLength;
            this.waveAnimationState.m_216977_(this.f_19797_);
        } else if (p_21375_ == 5) {
            this.waveAnimationTick = 0;
            this.waveAnimationState.m_216973_();
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, SpawnGroupData p_146749_, CompoundTag p_146750_) {
        this.setClawSize(this.f_19796_.m_188503_(3));
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public int getClawSize() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(CLAW_SIZE)), (int)0, (int)2);
    }

    public void setClawSize(int value) {
        this.clawGrowTime = this.randomClawGrowTime();
        this.f_19804_.m_135381_(CLAW_SIZE, (Object)value);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6898_(ItemStack p_29446_) {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_7848_(Animal p_29381_) {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_148993_, AgeableMob p_148994_) {
        return null;
    }

    class WaveGoal
    extends Goal {
        public int nextUseTime;

        public WaveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Crab.this.f_19797_ >= this.nextUseTime && Crab.this.f_19796_.m_188503_(100) == 0 && !this.shouldPanic() && !MiscUtils.isMovingOnLand((Entity)Crab.this) && !Crab.this.isClimbing();
        }

        public boolean m_8045_() {
            return !this.shouldPanic() && !MiscUtils.isMovingOnLand((Entity)Crab.this) && !Crab.this.isClimbing() && Crab.this.waveAnimationTick > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        protected boolean shouldPanic() {
            return Crab.this.m_21188_() != null || Crab.this.m_203117_() || Crab.this.m_6060_();
        }

        public void m_8056_() {
            super.m_8056_();
            Crab.this.waveAnimationTick = Crab.this.waveAnimationLength;
            Crab.this.m_9236_().m_7605_((Entity)Crab.this, (byte)4);
            Crab.this.m_5496_(SoundEvents.f_276434_, Crab.this.m_6121_(), Crab.this.m_6100_() / 4.0f);
        }

        public void m_8037_() {
            super.m_8037_();
            if (Crab.this.getClawSize() >= 2 && Crab.this.f_19796_.m_188503_(50) == 0 && Crab.this.waveAnimationTick == Crab.this.waveAnimationActionPoint) {
                Vec3 itemPos = PositionUtils.getOffsetPos((Entity)Crab.this, -0.5, 1.0, 0.0, 0.0f, Crab.this.f_20883_);
                Crab.this.setClawSize(0);
                ItemEntity itementity = new ItemEntity(Crab.this.m_9236_(), itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, new ItemStack((ItemLike)ItemInit.CRAB_CLAW.get()));
                itementity.m_32060_();
                itementity.lifespan = 1200;
                if (Crab.this.captureDrops() != null) {
                    Crab.this.captureDrops().add(itementity);
                } else {
                    Crab.this.m_9236_().m_7967_((Entity)itementity);
                }
                Crab.this.m_216990_(SoundEvents.f_12019_);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.nextUseTime = Crab.this.f_19797_ + 60;
            Crab.this.waveAnimationTick = 0;
            Crab.this.m_9236_().m_7605_((Entity)Crab.this, (byte)5);
        }
    }
}

