/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.Optional;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WakeUpEncounterHelper {
    public static boolean tryPerformEncounter(ServerPlayer player, ServerLevel level, BlockPos bedPos) {
        if (!level.m_46469_().m_46207_(GameRules.f_46134_)) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = bedPos.m_122032_();
        int monsterSpawnAttempts = CommonConfigs.ENCOUNTER_TRIES.get();
        int maxCount = CommonConfigs.ENCOUNTER_MAX_COUNT.get();
        int max = CommonConfigs.ENCOUNTER_RADIUS.get();
        int min = CommonConfigs.ENCOUNTER_MIN_RADIUS.get();
        int height = CommonConfigs.ENCOUNTER_HEIGHT.get();
        int count = 0;
        StructureManager struct = level.m_215010_();
        ChunkGenerator generator = level.m_7726_().m_8481_();
        MobCategory category = MobCategory.MONSTER;
        int maxAttempts = (int)((float)monsterSpawnAttempts * level.m_6436_(bedPos).m_19056_());
        for (int attempt = 0; attempt < maxAttempts && count < maxCount; ++attempt) {
            Mob mob;
            Object entity;
            WakeUpEncounterHelper.setRandomPosCyl(bedPos, mutable, level.f_46441_, min, max, height);
            Optional<EntityType<?>> spawnData = WakeUpEncounterHelper.getRandomEncounterData(level, struct, generator, category, (BlockPos)mutable);
            if (spawnData.isEmpty() || !((entity = WakeUpEncounterHelper.createValidMobToSpawn(player.m_20182_(), level, mutable, spawnData.get(), MobSpawnType.NATURAL)) instanceof Mob) || !(mob = (Mob)entity).m_142582_((Entity)player)) continue;
            WakeUpEncounterHelper.doSpawnMob(level, mob);
            WakeUpEncounterHelper.setupMobToTargetPlayer(player, mob);
            ++count;
        }
        return count != 0;
    }

    private static void doSpawnMob(ServerLevel level, Mob mob) {
        mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(mob.m_20183_()), MobSpawnType.EVENT, null, null);
        level.m_47205_((Entity)mob);
    }

    private static void setRandomPosCircle(BlockPos center, BlockPos.MutableBlockPos mutable, RandomSource random, int min, int max) {
        int l = random.m_216339_(min, max);
        Vec3 v = new Vec3((double)l, 0.0, 0.0).m_82524_(random.m_188501_() * (float)Math.PI * 2.0f).m_82496_(random.m_188501_() * (float)Math.PI);
        mutable.m_122169_((double)center.m_123341_() + 0.5 + v.f_82479_, (double)center.m_123342_() + 0.5 + v.f_82480_, (double)center.m_123343_() + 0.5 + v.f_82481_);
    }

    private static void setRandomPosCyl(BlockPos center, BlockPos.MutableBlockPos mutable, RandomSource random, int min, int max, int height) {
        int l = random.m_216339_(min, max);
        Vec3 v = new Vec3((double)l, (double)height * (random.m_188500_() - 0.5), 0.0).m_82524_(random.m_188501_() * (float)Math.PI * 2.0f);
        mutable.m_122169_((double)center.m_123341_() + 0.5 + v.f_82479_, (double)center.m_123342_() + 0.5 + v.f_82480_, (double)center.m_123343_() + 0.5 + v.f_82481_);
    }

    @Nullable
    private static <T extends Entity> T createValidMobToSpawn(Vec3 centerPos, ServerLevel level, BlockPos.MutableBlockPos pos, EntityType<T> entityType, MobSpawnType spawnType) {
        if (level.m_201918_((BlockPos)pos)) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = (double)pos.m_123343_() + 0.5;
            double y = pos.m_123342_();
            double f = centerPos.m_82531_(d, y, e);
            SpawnPlacements.Type type = SpawnPlacements.m_21752_(entityType);
            if (!(NaturalSpawner.m_47051_((SpawnPlacements.Type)type, (LevelReader)level, (BlockPos)pos, entityType) && SpawnPlacements.m_217074_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)level.f_46441_) && level.m_45772_(entityType.m_20585_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5)))) {
                return null;
            }
            Mob mob = NaturalSpawner.m_46988_((ServerLevel)level, entityType);
            if (mob == null) {
                return null;
            }
            mob.m_7678_(d, (double)pos.m_123342_(), e, level.f_46441_.m_188501_() * 360.0f, 0.0f);
            if (NaturalSpawner.m_46991_((ServerLevel)level, (Mob)mob, (double)f)) {
                return (T)mob;
            }
        }
        return null;
    }

    private static void setupMobToTargetPlayer(ServerPlayer player, Mob mob) {
        mob.m_21391_((Entity)player, 360.0f, 45.0f);
        mob.f_20885_ = mob.m_146908_();
        mob.f_20886_ = mob.m_146908_();
        mob.m_21563_().m_148051_((Entity)player);
        player.m_5796_();
        player.m_9107_(EntityAnchorArgument.Anchor.EYES, (Entity)mob, EntityAnchorArgument.Anchor.EYES);
        mob.m_6853_(true);
        Path path = mob.m_21573_().m_6570_((Entity)player, 0);
        if (path != null) {
            mob.m_6710_((LivingEntity)player);
        }
        mob.m_8032_();
    }

    private static Optional<EntityType<?>> getRandomEncounterData(ServerLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory category, BlockPos pos) {
        SimpleWeightedRandomList<EntityType<?>> list = CommonConfigs.ENCOUNTER_WHITELIST.get();
        if (!list.m_146337_()) {
            return list.m_216829_(level.f_46441_).map(WeightedEntry.Wrapper::m_146310_);
        }
        return WeightedRandomList.m_146328_(NaturalSpawner.m_220443_((ServerLevel)level, (StructureManager)structureManager, (ChunkGenerator)chunkGenerator, (MobCategory)category, (BlockPos)pos, (Holder)level.m_204166_(pos)).m_146338_().stream().filter(e -> !e.f_48404_.m_204039_(SleepTight.WAKE_UP_BLACKLIST)).toList()).m_216829_(level.f_46441_).map(e -> e.f_48404_);
    }

    public static boolean trySpawningBedbug(BlockPos bedPos, ServerPlayer player, BedData data) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (!level.m_46469_().m_46207_(GameRules.f_46134_)) {
            return false;
        }
        double spawnChance = CommonConfigs.BEDBUG_SPAWN_CHANCE.get();
        if ((double)level.f_46441_.m_188501_() < spawnChance) {
            if (CommonConfigs.PREVENTED_BY_DREAM_CATCHER.get().booleanValue() && DreamEssenceBlock.isInRange(bedPos, (Level)level)) {
                return false;
            }
            if (CommonConfigs.ONLY_WHEN_IN_HOME_BED.get().booleanValue() && (data == null || !data.isHomeBedFor((Player)player))) {
                return false;
            }
            BlockPos.MutableBlockPos mutable = bedPos.m_122032_();
            int monsterSpawnAttempts = CommonConfigs.BEDBUG_TRIES.get();
            int min = CommonConfigs.BEDBUG_SPAWN_MIN_RANGE.get();
            int max = CommonConfigs.BEDBUG_SPAWN_MAX_RANGE.get();
            int maxAttempts = (int)((float)monsterSpawnAttempts * (1.0f + level.m_6436_(bedPos).m_19057_()));
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                WakeUpEncounterHelper.setRandomPosCircle(bedPos, mutable, level.f_46441_, min, max);
                BedbugEntity mob = WakeUpEncounterHelper.createValidMobToSpawn(Vec3.m_82512_((Vec3i)mutable), level, mutable, SleepTight.BEDBUG_ENTITY.get(), MobSpawnType.EVENT);
                if (mob == null) continue;
                mob.m_6853_(true);
                Path path = mob.m_21573_().m_7864_((BlockPos)mutable, 0);
                if (path == null) continue;
                mob.setBedTarget((BlockPos)mutable);
                WakeUpEncounterHelper.doSpawnMob(level, (Mob)mob);
                return true;
            }
        }
        return false;
    }
}

