/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.configs.EffectData;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.integration.HeartstoneCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SleepEffectsHelper {
    public static void applyEffectsOnWakeUp(PlayerSleepData playerCap, ServerPlayer player, long dayTimeDelta, BlockPos pos, ISleepTightBed bed, BlockState state, @javax.annotation.Nullable BedData data) {
        if (data != null) {
            SleepEffectsHelper.applyVanillaBedBonuses(player, dayTimeDelta, data, playerCap);
            SleepEffectsHelper.applyHeartstoneBonuses(player, pos, state, data, playerCap);
        }
        if (player.f_8941_.m_9294_()) {
            if (bed.st_hasPenalties()) {
                SleepEffectsHelper.applySleepPenalties(player, dayTimeDelta);
            }
            if (bed.st_hasRequirements()) {
                SleepEffectsHelper.paySleepRequirements(player);
            }
        }
    }

    private static void applySleepPenalties(ServerPlayer player, long dayTimeDelta) {
        double hunger = CommonConfigs.CONSUMED_HUNGER.get();
        if (hunger == 0.0) {
            return;
        }
        CommonConfigs.HungerMode mode = CommonConfigs.CONSUME_HUNGER_MODE.get();
        if (mode == CommonConfigs.HungerMode.DIFFICULTY_BASED || mode == CommonConfigs.HungerMode.TIME_DIFFICULTY_BASED) {
            int diff = player.m_9236_().m_46791_().m_19028_();
            if (diff == 0) {
                return;
            }
            hunger *= 1.0 + (double)(diff - 1) * 0.25;
        }
        if (mode == CommonConfigs.HungerMode.TIME_BASED || mode == CommonConfigs.HungerMode.TIME_DIFFICULTY_BASED) {
            hunger = hunger / 11000.0 * (double)dayTimeDelta;
        }
        int level = player.m_36324_().m_38702_();
        level = (int)Mth.m_14008_((double)((double)level - hunger), (double)0.0, (double)20.0);
        player.m_36324_().m_38705_(level);
    }

    private static void applyVanillaBedBonuses(ServerPlayer player, long dayTimeDelta, BedData data, PlayerSleepData playerSleepData) {
        CommonConfigs.EffectIntensity potionClearing;
        CommonConfigs.BedStatus status = CommonConfigs.BED_BENEFITS.get();
        if (status == CommonConfigs.BedStatus.NONE) {
            return;
        }
        if (status == CommonConfigs.BedStatus.HOME_BED && !data.isHomeBedFor((Player)player)) {
            return;
        }
        CommonConfigs.EffectIntensity healing = CommonConfigs.HEALING.get();
        if (healing != CommonConfigs.EffectIntensity.NONE) {
            float maxHealth;
            float heal = maxHealth = player.m_21233_();
            if (healing == CommonConfigs.EffectIntensity.TIME_BASED) {
                heal = maxHealth / 12000.0f * (float)dayTimeDelta;
            }
            player.m_5634_(heal);
        }
        if ((potionClearing = CommonConfigs.EFFECT_CLEARING.get()) != CommonConfigs.EffectIntensity.NONE) {
            CommonConfigs.PotionClearing type = CommonConfigs.EFFECT_CLEARING_TYPE.get();
            boolean timeBased = potionClearing == CommonConfigs.EffectIntensity.TIME_BASED;
            ArrayList<MobEffectInstance> toEditOrRemove = new ArrayList<MobEffectInstance>();
            block5: for (MobEffectInstance e : player.m_21220_()) {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case ALL: {
                        break;
                    }
                    case HARMFUL: {
                        if (e.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue block5;
                        break;
                    }
                    case BENEFICIAL: {
                        if (e.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) continue block5;
                    }
                }
                toEditOrRemove.add(e);
            }
            for (MobEffectInstance e : toEditOrRemove) {
                long remainingTime;
                player.m_21195_(e.m_19544_());
                if (!timeBased || (remainingTime = (long)e.m_19557_() - dayTimeDelta) <= 0L) continue;
                CompoundTag tag = new CompoundTag();
                e.m_19555_(tag);
                tag.m_128405_("Duration", (int)remainingTime);
                MobEffectInstance load = MobEffectInstance.m_19560_((CompoundTag)tag);
                if (load == null) continue;
                player.m_7292_(load);
            }
        }
        for (EffectData e : CommonConfigs.WAKE_UP_EFFECTS.get()) {
            player.m_7292_(e.createInstance(playerSleepData.getHomeBedLevel()));
        }
    }

    private static void applyHeartstoneBonuses(ServerPlayer player, BlockPos pos, BlockState state, @javax.annotation.Nullable BedData data, PlayerSleepData playerSleepData) {
        BlockPos otherPos = SleepEffectsHelper.getPartnerPos((Player)player, state, pos);
        if (otherPos != null) {
            for (EffectData e : CommonConfigs.HEARTSTONE_EFFECT.get()) {
                player.m_7292_(e.createInstance(playerSleepData.getHomeBedLevel()));
            }
        }
    }

    private static void paySleepRequirements(ServerPlayer serverPlayer) {
        serverPlayer.m_6756_(-CommonConfigs.XP_COST.get().intValue());
    }

    public static boolean checkExtraRequirements(Player player, @javax.annotation.Nullable BlockPos bedPos) {
        if (bedPos != null && !player.m_150110_().f_35937_) {
            Level level = player.m_9236_();
            BlockEntity tile = level.m_7702_(bedPos);
            if (tile == null && !CommonConfigs.REQUIREMENT_NIGHT_BAG.get().booleanValue()) {
                return true;
            }
            if (tile instanceof HammockTile && !CommonConfigs.REQUIREMENT_HAMMOCK.get().booleanValue()) {
                return true;
            }
            if (!CommonConfigs.REQUIREMENT_BED.get().booleanValue()) {
                return true;
            }
            int xp = CommonConfigs.XP_COST.get();
            if (xp != 0 && player.f_36079_ < xp) {
                if (level.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.sleep_tight.xp"), true);
                }
                return false;
            }
            if (CommonConfigs.NEED_FULL_HUNGER.get().booleanValue() && player.m_36324_().m_38721_()) {
                if (level.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.sleep_tight.hunger"), true);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static BlockPos getPartnerPos(Player player, BlockState state, BlockPos pos) {
        CommonConfigs.HeartstoneMode mode = CommonConfigs.HEARTSTONE_MODE.get();
        Level level = player.m_9236_();
        if (mode.isOn() && state.m_60734_() instanceof BedBlock) {
            BlockPos otherPos = BedEntity.getDoubleBedPos(pos, state);
            boolean x = SleepEffectsHelper.hasPartnerAt(player, mode, level, otherPos);
            if (!x) {
                otherPos = BedEntity.getInverseDoubleBedPos(pos, state);
                x = SleepEffectsHelper.hasPartnerAt(player, mode, level, otherPos);
            }
            if (x) {
                return otherPos;
            }
        }
        return null;
    }

    private static boolean hasPartnerAt(Player player, CommonConfigs.HeartstoneMode mode, Level level, BlockPos otherPos) {
        BlockState leftState = level.m_8055_(otherPos);
        if (leftState.m_60734_() instanceof BedBlock && ((Boolean)leftState.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
            AABB bb = new AABB(otherPos);
            Iterator iterator = level.m_6443_(Player.class, bb, v -> v.m_21257_().map(p -> p.equals((Object)otherPos)).orElse(false)).iterator();
            if (iterator.hasNext()) {
                Player p = (Player)iterator.next();
                if (mode == CommonConfigs.HeartstoneMode.WITH_MOD) {
                    return HeartstoneCompat.isFren(player, p);
                }
                return true;
            }
            List vl = level.m_6443_(Villager.class, bb, v -> v.m_21257_().map(p -> p.equals((Object)otherPos)).orElse(false));
            return !vl.isEmpty();
        }
        return false;
    }
}

