/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.tiles;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.network.AccelerateHammockMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.network.ServerBoundFallFromHammockMessage;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class HammockTile
extends BlockEntity {
    private final DyeColor color;
    private boolean accelerateLeft;
    private boolean accelerateRight;
    private float pivotOffset;
    private Direction direction;
    private float prevAngle;
    private float angle;
    private float angularVel = 0.0f;
    private boolean hasDrag = true;

    public HammockTile(BlockPos blockPos, BlockState blockState) {
        super(SleepTight.HAMMOCK_TILE.get(), blockPos, blockState);
        this.color = ((HammockBlock)blockState.m_60734_()).getColor();
        this.pivotOffset = ((HammockPart)((Object)blockState.m_61143_(HammockBlock.PART))).getPivotOffset();
        this.direction = (Direction)blockState.m_61143_((Property)HammockBlock.f_54117_);
        this.angle = PlatHelper.getPhysicalSide().isClient() ? 0.0f * (float)(((double)RandomSource.m_216327_().m_188501_() - 0.5) * Math.toRadians(ClientConfigs.HAMMOCK_MIN_ANGLE.get())) : 0.0f;
    }

    private static double calculateEnergy(float k, float vel, float angle) {
        return (double)((1.0f - Mth.m_14089_((float)angle)) * k) + 0.5 * (double)(vel * vel);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public float getRoll(float partialTicks) {
        if (!ClientConfigs.HAMMOCK_ANIMATION.get().booleanValue()) {
            return 0.0f;
        }
        return 57.295776f * Mth.m_14189_((float)partialTicks, (float)this.prevAngle, (float)this.angle);
    }

    public float getPivotOffset() {
        return this.pivotOffset;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-3, 0, -3), this.f_58858_.m_7918_(3, 2, 3));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HammockTile e) {
        boolean hasAcc;
        e.prevAngle = e.angle;
        float dt = 0.05f;
        double energy = 0.0;
        float k = ClientConfigs.getK();
        boolean bl = hasAcc = e.accelerateLeft || e.accelerateRight;
        if (hasAcc) {
            e.hasDrag = true;
        }
        if (e.hasDrag) {
            energy = HammockTile.calculateEnergy(k, e.angularVel, e.angle);
        }
        if (hasAcc && energy < (double)ClientConfigs.getMaxAngleEnergy()) {
            double push = ClientConfigs.SWING_FORCE.get();
            e.angularVel = (float)((double)e.angularVel + push * (double)(e.accelerateLeft ? -1 : 1));
            NetworkHandler.CHANNEL.sendToServer((Message)new AccelerateHammockMessage(pos, e.accelerateLeft));
        }
        float acc = -k * Mth.m_14031_((float)e.angle);
        if (e.hasDrag && !hasAcc) {
            if (energy > (double)ClientConfigs.getMinAngleEnergy()) {
                double damping = ClientConfigs.DAMPING.get();
                float drag = (float)(damping * (double)e.angularVel);
                acc -= drag;
            } else {
                e.hasDrag = false;
            }
        }
        e.angularVel += dt * acc;
        e.angle += e.angularVel * dt;
        e.pivotOffset = ((HammockPart)((Object)state.m_61143_(HammockBlock.PART))).getPivotOffset();
        e.direction = (Direction)state.m_61143_((Property)HammockBlock.f_54117_);
        e.accelerateLeft = false;
        e.accelerateRight = false;
        if ((double)Mth.m_14154_((float)e.angle) > 1.3707963705062867 && ClientConfigs.HAMMOCK_FALL.get().booleanValue()) {
            for (BedEntity b : e.f_58857_.m_45976_(BedEntity.class, new AABB(pos))) {
                for (Entity p : b.m_20197_()) {
                    Player pp;
                    if (p instanceof Player && (pp = (Player)p).m_7578_()) {
                        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundFallFromHammockMessage());
                        continue;
                    }
                    return;
                }
            }
        }
    }

    public void accelerateLeft() {
        this.accelerateLeft = true;
    }

    public void accelerateRight() {
        this.accelerateRight = true;
    }

    public void addImpulse(double vel) {
        this.angularVel = (float)((double)this.angularVel + vel);
        this.hasDrag = true;
    }
}

