/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.dynamicresources.DynamicBakedModelProvider;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBakery.class}, priority=1100)
@ClientOnlyMixin
public abstract class ModelBakeryMixin
implements IExtendedModelBakery {
    private static final boolean debugDynamicModelLoading = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    @Shadow
    @Final
    @Mutable
    public Map<ResourceLocation, UnbakedModel> f_119212_;
    @Shadow
    @Final
    public static ModelResourceLocation f_119230_;
    @Shadow
    @Final
    private Set<ResourceLocation> f_119210_;
    @Shadow
    @Final
    @Mutable
    private Map<ResourceLocation, BakedModel> f_119215_;
    @Shadow
    @Final
    @Mutable
    private Map<ModelBakery.BakedCacheKey, BakedModel> f_119213_;
    @Shadow
    @Final
    @Mutable
    private BlockColors f_119209_;
    @Shadow
    @Final
    private static Logger f_119235_;
    private Cache<ModelBakery.BakedCacheKey, BakedModel> loadedBakedModels;
    private Cache<ResourceLocation, UnbakedModel> loadedModels;
    private HashMap<ResourceLocation, UnbakedModel> smallLoadingCache = new HashMap();
    private boolean ignoreModelLoad;
    private boolean fabric_enableGetOrLoadModelGuard;
    private UnbakedModel missingModel;
    private Set<ResourceLocation> blockStateFiles;
    private Set<ResourceLocation> modelFiles;
    private BiFunction<ResourceLocation, Material, TextureAtlasSprite> textureGetter;
    private int mfix$nestedLoads = 0;
    private BakedModel bakedMissingModel = null;

    @Shadow
    protected abstract BlockModel m_119364_(ResourceLocation var1) throws IOException;

    @Shadow
    protected abstract void m_119362_(ResourceLocation var1) throws Exception;

    @Shadow
    public abstract void m_119306_(ModelResourceLocation var1);

    @Shadow
    public abstract UnbakedModel m_119341_(ResourceLocation var1);

    @Redirect(method={"<init>"}, at=@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/resources/model/ModelBakery;blockColors:Lnet/minecraft/client/color/block/BlockColors;"))
    private void replaceTopLevelBakedModels(ModelBakery bakery, BlockColors val) {
        this.fabric_enableGetOrLoadModelGuard = false;
        this.f_119209_ = val;
        this.loadedBakedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.loadedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.f_119213_ = this.loadedBakedModels.asMap();
        final ConcurrentMap unbakedCacheBackingMap = this.loadedModels.asMap();
        this.f_119212_ = new ForwardingMap<ResourceLocation, UnbakedModel>(){

            protected Map<ResourceLocation, UnbakedModel> delegate() {
                return unbakedCacheBackingMap;
            }

            public UnbakedModel put(ResourceLocation key, UnbakedModel value) {
                ModelBakeryMixin.this.smallLoadingCache.put(key, value);
                return (UnbakedModel)super.put((Object)key, (Object)value);
            }
        };
        this.f_119215_ = new DynamicBakedModelProvider((ModelBakery)this, this.f_119213_);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal=0), index=0)
    private String ignoreFutureModelLoads(String name) {
        this.ignoreModelLoad = true;
        return name;
    }

    private <K, V> void onModelRemoved(RemovalNotification<K, V> notification) {
        ResourceLocation rl;
        if (!debugDynamicModelLoading) {
            return;
        }
        Object k = notification.getKey();
        if (k == null) {
            return;
        }
        boolean baked = false;
        if (k instanceof ResourceLocation) {
            rl = (ResourceLocation)k;
        } else {
            rl = ((ModelBakery.BakedCacheKey)k).f_243934_();
            baked = true;
        }
        if (!baked && this.loadedModels.getIfPresent((Object)rl) != null) {
            return;
        }
        ModernFix.LOGGER.warn("Evicted {} model {}", (Object)(baked ? "baked" : "unbaked"), (Object)rl);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0), index=1)
    private Object captureMissingModel(Object model) {
        this.missingModel = (UnbakedModel)model;
        this.blockStateFiles = new HashSet<ResourceLocation>();
        this.modelFiles = new HashSet<ResourceLocation>();
        return this.missingModel;
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelBakery;loadTopLevel(Lnet/minecraft/client/resources/model/ModelResourceLocation;)V"))
    private void addTopLevelFile(ModelBakery bakery, ModelResourceLocation location) {
        if (location == f_119230_ || !this.ignoreModelLoad) {
            this.m_119306_(location);
        }
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V", ordinal=0))
    private void fetchStaticDefinitions(Map<ResourceLocation, StateDefinition<Block, BlockState>> map, BiConsumer<ResourceLocation, StateDefinition<Block, BlockState>> func) {
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;", ordinal=0))
    private ImmutableList<BlockState> fetchBlocks(StateDefinition<Block, BlockState> def) {
        return ImmutableList.of();
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;", ordinal=0))
    private Collection<?> copyTopLevelModelList(Map<?, ?> map) {
        return new ArrayList(map.values());
    }

    @Inject(method={"bakeModels"}, at={@At(value="HEAD")})
    private void captureGetter(BiFunction<ResourceLocation, Material, TextureAtlasSprite> getter, CallbackInfo ci) {
        this.ignoreModelLoad = false;
        this.textureGetter = getter;
        DynamicBakedModelProvider.currentInstance = (DynamicBakedModelProvider)this.f_119215_;
    }

    @Redirect(method={"bakeModels"}, at=@At(value="INVOKE", target="Ljava/util/Map;keySet()Ljava/util/Set;"))
    private Set<ResourceLocation> skipBake(Map<ResourceLocation, UnbakedModel> instance) {
        HashSet<ResourceLocation> modelSet = new HashSet<ResourceLocation>(instance.keySet());
        if (modelSet.size() > 0) {
            ModernFix.LOGGER.info("Early baking {} models", (Object)modelSet.size());
        }
        return modelSet;
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private Object getMissingModel(Map map, Object rl) {
        if (rl == f_119230_ && map == this.f_119212_) {
            return this.missingModel;
        }
        return this.f_119212_.get(rl);
    }

    @ModifyVariable(method={"cacheAndQueueDependencies"}, at=@At(value="HEAD"), argsOnly=true)
    private UnbakedModel fireUnbakedEvent(UnbakedModel model, ResourceLocation location) {
        for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
            try {
                model = integration.onUnbakedModelLoad(location, model, (ModelBakery)this);
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Exception firing model load event for {}", (Object)location, (Object)e);
            }
        }
        return model;
    }

    @Inject(method={"cacheAndQueueDependencies"}, at={@At(value="RETURN")})
    private void addToSmallLoadingCache(ResourceLocation location, UnbakedModel model, CallbackInfo ci) {
        this.smallLoadingCache.put(location, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getModel"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOrLoadModelDynamic(ResourceLocation modelLocation, CallbackInfoReturnable<UnbakedModel> cir) {
        if (modelLocation.equals((Object)f_119230_)) {
            cir.setReturnValue((Object)this.missingModel);
            return;
        }
        UnbakedModel existing = this.f_119212_.get(modelLocation);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                if (this.f_119210_.contains(modelLocation)) {
                    throw new IllegalStateException("Circular reference while loading " + modelLocation);
                }
                this.f_119210_.add(modelLocation);
                UnbakedModel iunbakedmodel = this.missingModel;
                while (!this.f_119210_.isEmpty()) {
                    ResourceLocation resourcelocation = this.f_119210_.iterator().next();
                    ++this.mfix$nestedLoads;
                    try {
                        existing = this.f_119212_.get(resourcelocation);
                        if (existing == null) {
                            if (debugDynamicModelLoading) {
                                f_119235_.info("Loading {}", (Object)resourcelocation);
                            }
                            this.m_119362_(resourcelocation);
                            continue;
                        }
                        this.smallLoadingCache.put(resourcelocation, existing);
                    }
                    catch (ModelBakery.BlockStateDefinitionException var9) {
                        f_119235_.warn(var9.getMessage());
                        this.f_119212_.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    catch (Exception var10) {
                        f_119235_.warn("Unable to load model: '{}' referenced from: {}: {}", new Object[]{resourcelocation, modelLocation, var10});
                        this.f_119212_.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    finally {
                        --this.mfix$nestedLoads;
                        this.f_119210_.remove(resourcelocation);
                    }
                }
                UnbakedModel result = this.smallLoadingCache.getOrDefault(modelLocation, iunbakedmodel);
                try {
                    result.m_5500_(this::m_119341_);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (this.mfix$nestedLoads == 0) {
                    this.smallLoadingCache.clear();
                }
                cir.setReturnValue((Object)result);
            }
        }
    }

    private <T extends Comparable<T>, V extends T> BlockState setPropertyGeneric(BlockState state, Property<T> prop, Object o) {
        return (BlockState)state.m_61124_(prop, (Comparable)o);
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;"))
    private ImmutableList<BlockState> loadOnlyRelevantBlockState(StateDefinition<Block, BlockState> stateDefinition, ResourceLocation location) {
        if (!(location instanceof ModelResourceLocation) || Minecraft.m_91087_().f_91073_ == null) {
            return stateDefinition.m_61056_();
        }
        return ModelBakeryHelpers.getBlockStatesForMRL(stateDefinition, (ModelResourceLocation)location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BakedModel bakeDefault(ResourceLocation modelLocation, ModelState state) {
        ModelBakery self;
        ModelBakery.BakedCacheKey key = new ModelBakery.BakedCacheKey(modelLocation, BlockModelRotation.X0_Y0.m_6189_(), BlockModelRotation.X0_Y0.m_7538_());
        BakedModel m = (BakedModel)this.loadedBakedModels.getIfPresent((Object)key);
        if (m != null) {
            return m;
        }
        ModelBakery modelBakery = self = (ModelBakery)this;
        Objects.requireNonNull(modelBakery);
        ModelBakery.ModelBakerImpl theBaker = new ModelBakery.ModelBakerImpl(modelBakery, this.textureGetter, modelLocation);
        ModelBakeryMixin modelBakeryMixin = this;
        synchronized (modelBakeryMixin) {
            m = theBaker.bake(modelLocation, state, theBaker.getModelTextureGetter());
        }
        if (m != null) {
            this.loadedBakedModels.put((Object)key, (Object)m);
        }
        return m;
    }

    @Override
    public ImmutableList<BlockState> getBlockStatesForMRL(StateDefinition<Block, BlockState> stateDefinition, ModelResourceLocation location) {
        return this.loadOnlyRelevantBlockState(stateDefinition, (ResourceLocation)location);
    }

    @Override
    public void setBakedMissingModel(BakedModel m) {
        this.bakedMissingModel = m;
    }

    @Override
    public BakedModel getBakedMissingModel() {
        return this.bakedMissingModel;
    }

    @Override
    public UnbakedModel mfix$getUnbakedMissingModel() {
        return this.missingModel;
    }
}

