/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.misc;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CaveBookProgress {
    public static final String PLAYER_CAVE_BOOK_PROGRESS_TAG = "AlexsCavesBookProgress";
    private Map<String, Subcategory> unlockedPages = new HashMap<String, Subcategory>();

    private CaveBookProgress(CompoundTag tag) {
        if (tag.m_128441_("Pages")) {
            ListTag listTag = tag.m_128437_("Pages", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundtag = listTag.m_128728_(i);
                this.unlockedPages.put(compoundtag.m_128461_("Category"), Subcategory.getByOrdinal(compoundtag.m_128451_("SubCategory")));
            }
        }
    }

    public static CaveBookProgress getCaveBookProgress(Player player) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)player);
        CompoundTag tag1 = tag.m_128441_(PLAYER_CAVE_BOOK_PROGRESS_TAG) ? tag.m_128469_(PLAYER_CAVE_BOOK_PROGRESS_TAG) : new CompoundTag();
        return new CaveBookProgress(tag1);
    }

    public static void saveCaveBookProgress(CaveBookProgress caveBookProgress, Player player) {
        CompoundTag savedTag = caveBookProgress.save();
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)player);
        tag.m_128365_(PLAYER_CAVE_BOOK_PROGRESS_TAG, (Tag)savedTag);
        CitadelEntityData.setCitadelTag((LivingEntity)player, (CompoundTag)tag);
        if (!player.m_9236_().f_46443_) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelTagUpdate", tag, player.m_19879_()));
        } else {
            Citadel.sendMSGToServer((Object)new PropertiesMessage("CitadelTagUpdate", tag, player.m_19879_()));
        }
    }

    private CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry<String, Subcategory> entry : this.unlockedPages.entrySet()) {
            CompoundTag innerTag = new CompoundTag();
            innerTag.m_128359_("Category", entry.getKey());
            innerTag.m_128405_("SubCategory", entry.getValue().ordinal());
            listTag.add((Object)innerTag);
        }
        tag.m_128365_("Pages", (Tag)listTag);
        return tag;
    }

    public boolean unlockNextFor(String biomeCategory) {
        int prev = this.unlockedPages.getOrDefault(biomeCategory, Subcategory.EMPTY).ordinal();
        if (prev >= Subcategory.values().length - 1) {
            return false;
        }
        this.unlockedPages.put(biomeCategory, Subcategory.getByOrdinal(prev + 1));
        return true;
    }

    public boolean isUnlockedFor(String biomeCategory, Subcategory subcategory) {
        int prev = this.unlockedPages.getOrDefault(biomeCategory, Subcategory.EMPTY).ordinal();
        return subcategory.ordinal() <= prev;
    }

    public Subcategory getLastUnlockedCategory(String biomeCategory) {
        return this.unlockedPages.getOrDefault(biomeCategory, Subcategory.EMPTY);
    }

    public boolean isUnlockedFor(String key) {
        int lastIndexOfUnderscore = key.lastIndexOf("_");
        if (lastIndexOfUnderscore >= 0 && lastIndexOfUnderscore + 1 < key.length()) {
            String biomeCategory = key.substring(0, lastIndexOfUnderscore);
            String subCatStr = key.substring(lastIndexOfUnderscore + 1);
            Subcategory subcategory = Subcategory.valueOf(subCatStr.toUpperCase(Locale.ROOT));
            return this.isUnlockedFor(biomeCategory, subcategory);
        }
        return false;
    }

    public static enum Subcategory {
        EMPTY,
        GENERAL,
        RESOURCES,
        MOBS,
        UTILITIES;


        public static Subcategory getByOrdinal(int subCategory) {
            return Subcategory.values()[Mth.m_14045_((int)subCategory, (int)0, (int)(Subcategory.values().length - 1))];
        }
    }
}

