/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure;

import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.ACStructureRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.AbstractCaveGenerationStructure;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.OceanTrenchStructurePiece;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class OceanTrenchStructure
extends AbstractCaveGenerationStructure {
    private static final int BOWL_WIDTH_RADIUS = 150;
    public static final Codec<OceanTrenchStructure> CODEC = OceanTrenchStructure.m_226607_(settings -> new OceanTrenchStructure((Structure.StructureSettings)settings));

    public OceanTrenchStructure(Structure.StructureSettings settings) {
        super(settings, ACBiomeRegistry.ABYSSAL_CHASM);
    }

    @Override
    protected StructurePiece createPiece(BlockPos offset, BlockPos center, int heightBlocks, int widthBlocks, RandomState randomState) {
        return new OceanTrenchStructurePiece(offset, center, heightBlocks, widthBlocks);
    }

    @Override
    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int i = context.f_226628_().m_45604_();
        int j = context.f_226628_().m_45605_();
        BlockPos center = new BlockPos(i, this.getGenerateYHeight(context.f_226626_(), i, j), j);
        int heightRad = this.getHeightRadius(context.f_226626_(), context.f_226622_().m_6337_());
        int widthRad = this.getWidthRadius(context.f_226626_());
        int biomeUp = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.UP, center, heightRad) + this.getYExpand();
        int biomeDown = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.DOWN, center, heightRad) + this.getYExpand();
        BlockPos ground = center.m_6625_(biomeDown - 2);
        int biomeEast = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.EAST, ground, widthRad) + 32;
        int biomeWest = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.WEST, ground, widthRad) + 32;
        int biomeNorth = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.NORTH, ground, widthRad) + 32;
        int biomeSouth = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.SOUTH, ground, widthRad) + 32;
        int widthBlocks = (biomeEast + biomeWest + biomeNorth + biomeSouth) / 4;
        int heightBlocks = (biomeUp + biomeDown) / 2;
        int widthChunks = (int)Math.ceil((float)(widthBlocks + 16) / 16.0f / 2.0f) + 3;
        for (int chunkX = -widthChunks; chunkX <= widthChunks; ++chunkX) {
            for (int chunkZ = -widthChunks; chunkZ <= widthChunks; ++chunkZ) {
                StructurePiece piece = this.createPiece(center.m_121955_((Vec3i)new BlockPos(chunkX * 16, 0, chunkZ * 16)), center, heightBlocks, widthBlocks, context.f_226624_());
                builder.m_142679_(piece);
            }
        }
    }

    @Override
    public int getGenerateYHeight(WorldgenRandom random, int x, int y) {
        return -16;
    }

    @Override
    public int getWidthRadius(WorldgenRandom random) {
        return 150;
    }

    @Override
    public int getHeightRadius(WorldgenRandom random, int seaLevel) {
        return 64;
    }

    @Override
    protected int getYExpand() {
        return 16;
    }

    @Override
    protected int getHeightOverride(int heightIn) {
        return Integer.MAX_VALUE;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ACStructureRegistry.OCEAN_TRENCH.get();
    }
}

